// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: SpringServiceLocator.vsl in andromda-spring-cartridge.
//
package fr.ifremer.adagio.core.service;

import fr.ifremer.adagio.core.service.referential.location.LocationService;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.AbstractApplicationContext;

/**
 * Locates and provides all available application services.
 */
public class ServiceLocator {

    /**
     * The default bean reference factory location.
     */
    private static final String DEFAULT_BEAN_REFERENCE_LOCATION = "beanRefFactory.xml";

    /**
     * The default bean reference factory ID.
     */
    private static final String DEFAULT_BEAN_REFERENCE_ID = "beanRefFactory";

    /**
     * The shared instance of this ServiceLocator.
     */
    private final static ServiceLocator instance = new ServiceLocator();

	protected ServiceLocator() {
		// shouldn't be instantiated
        init(null, null);
	}

    protected ServiceLocator(String beanFactoryReferenceLocation,
                             String beanRefFactoryReferenceId) {
        init(beanFactoryReferenceLocation, beanRefFactoryReferenceId);
    }

	/**
	 * Gets the shared instance of this Class
	 *
	 * @return the shared service locator instance.
	 */
	public static ServiceLocator instance() {
		return instance;
	}

	/**
	 * The bean factory reference instance.
	 */
	private BeanFactoryReference beanFactoryReference;

	/**
	 * The bean factory reference location.
	 */
	private String beanFactoryReferenceLocation;

	/**
	 * The bean factory reference id.
	 */
	private String beanRefFactoryReferenceId;

	/**
	 * Initializes the Spring application context from the given <code>beanFactoryReferenceLocation</code>. If <code>null</code> is
	 * specified for the <code>beanFactoryReferenceLocation</code> then the
	 * default application context will be used.
	 *
	 * @param beanFactoryReferenceLocation
	 *            the location of the beanRefFactory reference.
	 */
	public synchronized void init(String beanFactoryReferenceLocation,
			String beanRefFactoryReferenceId) {
        this.beanFactoryReferenceLocation =
                beanFactoryReferenceLocation == null ?
                DEFAULT_BEAN_REFERENCE_LOCATION :
                beanFactoryReferenceLocation;
        this.beanRefFactoryReferenceId = beanRefFactoryReferenceId == null ?
                                         DEFAULT_BEAN_REFERENCE_ID :
                                         beanRefFactoryReferenceId;
        this.beanFactoryReference = null;
    }

	/**
	 * Initializes the Spring application context from the given <code>beanFactoryReferenceLocation</code>. If <code>null</code> is
	 * specified for the <code>beanFactoryReferenceLocation</code> then the
	 * default application context will be used.
	 *
	 * @param beanFactoryReferenceLocation
	 *            the location of the beanRefFactory reference.
	 */
	public synchronized void init(String beanFactoryReferenceLocation) {
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation == null ?
                                            DEFAULT_BEAN_REFERENCE_LOCATION :
                                            beanFactoryReferenceLocation;
        this.beanFactoryReference = null;
    }

	/**
	 * Shuts down the ServiceLocator and releases any used resources.
	 */
	public synchronized void shutdown() {
		((AbstractApplicationContext) getContext()).close();
		if (beanFactoryReference != null) {
			beanFactoryReference.release();
			beanFactoryReference = null;
		}
	}

    /**
     * Get a service.
     *
     * @param name name of the service (i.e name of the srping bean)
     * @param serviceType type of service
     * @param <S> type of the service
     * @return the instanciated service
     */
    public <S> S getService(String name, Class<S> serviceType) {
        return getContext().getBean(name, serviceType);
    }

	/**
	 * Gets an instance of {@link LocationService}.
	 */
	public final LocationService getLocationService() {
		return getService("locationService", LocationService.class);
	}

    /**
     * Gets the Spring ApplicationContext.
     */
    protected synchronized ApplicationContext getContext() {
        if (beanFactoryReference == null) {
            BeanFactoryLocator beanFactoryLocator =
                    ContextSingletonBeanFactoryLocator.getInstance(
                            beanFactoryReferenceLocation);
            beanFactoryReference = beanFactoryLocator
                    .useBeanFactory(beanRefFactoryReferenceId);
        }
        return (ApplicationContext) beanFactoryReference.getFactory();
    }
}