// license-header java merge-point
//
// Attention: Generated code! Do not modify by hand!
// Generated by: HibernateEntity.vsl in andromda-hibernate-cartridge.
//
package fr.ifremer.adagio.core.dao.referential.taxon;

/**
 * <p>
 * Liste des rangs taxinomiques possibles.
 * </p>
 * <p>
 * C’est le nom du rang dans la classification systématique ; les
 * niveaux systématiques sont désignés par des termes consacrés
 * (ex. : espèce, genre, famille, etc.). Le niveau systématique
 * d’un taxon peut changer avec l’évolution de la classification ;
 * dans ce cas, son libellé est susceptible de changer également
 * car les suffixes notamment obéissent à des règles strictes de
 * nomenclature (règle [R0018]).
 * </p>
 * <p>
 * Les niveaux systématiques pris en compte dans le référentiel
 * taxinomique Quadrige² sont (par ordre de rang) (le nom anglais
 * de chaque niveau est indiqué entre parenthèses) :
 * </p>
 * <p>
 * -	Règne (kingdom)
 * </p>
 * <p>
 * -	Sous-règne (subkingdom)
 * </p>
 * <p>
 * -	Division (division) / Embranchement (phylum)
 * </p>
 * <p>
 * -	Subdivision (subdivision) / Sous-embranchement (subphylum)
 * </p>
 * <p>
 * -	Super-classe (superclass)
 * </p>
 * <p>
 * -	Classe (class)
 * </p>
 * <p>
 * -	Sous-classe (subclass)
 * </p>
 * <p>
 * -	Infra-classe (infraclass)
 * </p>
 * <p>
 * -	Super-ordre (superordo)
 * </p>
 * <p>
 * -	Ordre (ordo)
 * </p>
 * <p>
 * -	Sous-ordre (subordo)
 * </p>
 * <p>
 * -	Infra-ordre (infraordo)
 * </p>
 * <p>
 * -	Section (section)
 * </p>
 * <p>
 * -	Sous-section (subsection)
 * </p>
 * <p>
 * -	Super-famille (superfamily)
 * </p>
 * <p>
 * -	Famille (family)
 * </p>
 * <p>
 * -	Sous-famille (subfamily)
 * </p>
 * <p>
 * -	Tribu (tribe)
 * </p>
 * <p>
 * -	Sous-tribu (subtribe)
 * </p>
 * <p>
 * -	Genre (genus)
 * </p>
 * <p>
 * -	Sous-genre (subgenus)
 * </p>
 * <p>
 * -	Espèce (species)
 * </p>
 * <p>
 * -	Sous-espèce (subspecies)
 * </p>
 * <p>
 * -	Variété (variety)
 * </p>
 * <p>
 * -	Sous-variété (subvariety)
 * </p>
 * <p>
 * -	Forme (forma)
 * </p>
 * <p>
 * -	Sous-forme (subforma)
 * </p>
 * <p>
 * -	Incertae sedis (dummy = taxons inclassables)
 * </p>
 */
public abstract class TaxonomicLevel
    implements java.io.Serializable
{
    /**
     * The serial version UID of this class. Needed for serialization.
     */
    private static final long serialVersionUID = -5844665311921377024L;

    private java.lang.String code;

    /**
     * <p>
     * Code unique identifiant le rang taxinomique.
     * </p>
     */
    public java.lang.String getCode()
    {
        return this.code;
    }

    public void setCode(java.lang.String code)
    {
        this.code = code;
    }

    private java.lang.Integer rank;

    /**
     * <p>
     * Numéro du rang taxinomique.
     * </p>
     * <p>
     * Croissant du règne vers l'espèce
     * </p>
     * <p>
     * Ceci permet de limiter le choix des niveaux fils aux numéros
     * supérieurs
     * </p>
     */
    public java.lang.Integer getRank()
    {
        return this.rank;
    }

    public void setRank(java.lang.Integer rank)
    {
        this.rank = rank;
    }

    private java.lang.String name;

    /**
     * <p>
     * Libellé du rang taxinomique
     * </p>
     */
    public java.lang.String getName()
    {
        return this.name;
    }

    public void setName(java.lang.String name)
    {
        this.name = name;
    }

    private java.lang.String label;

    /**
     * <p>
     * Mnémonique du rang taxinomique
     * </p>
     */
    public java.lang.String getLabel()
    {
        return this.label;
    }

    public void setLabel(java.lang.String label)
    {
        this.label = label;
    }

    private java.lang.String comments;

    /**
     * <p>
     * Commentaire décrivant le rang taxinomique
     * </p>
     */
    public java.lang.String getComments()
    {
        return this.comments;
    }

    public void setComments(java.lang.String comments)
    {
        this.comments = comments;
    }

    private java.util.Date creationDate;

    /**
     * <p>
     * Date de création système du niveau. Renseigné automatiquement
     * par le système.
     * </p>
     */
    public java.util.Date getCreationDate()
    {
        return this.creationDate;
    }

    public void setCreationDate(java.util.Date creationDate)
    {
        this.creationDate = creationDate;
    }

    private java.sql.Timestamp updateDate;

    /**
     * <p>
     * Date de mise à jour système du niveau. Renseigné automatiquement
     * par le système.
     * </p>
     */
    public java.sql.Timestamp getUpdateDate()
    {
        return this.updateDate;
    }

    public void setUpdateDate(java.sql.Timestamp updateDate)
    {
        this.updateDate = updateDate;
    }


    private fr.ifremer.adagio.core.dao.referential.Status status;

    /**
     * 
     */
    public fr.ifremer.adagio.core.dao.referential.Status getStatus()
    {
        return this.status;
    }

    public void setStatus(fr.ifremer.adagio.core.dao.referential.Status status)
    {
        this.status = status;
    }


    private java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonName> taxonNames = new java.util.HashSet<fr.ifremer.adagio.core.dao.referential.taxon.TaxonName>();

    /**
     * 
     */
    public java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonName> getTaxonNames()
    {
        return this.taxonNames;
    }

    public void setTaxonNames(java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonName> taxonNames)
    {
        this.taxonNames = taxonNames;
    }

    /**
     * This entity does not have any identifiers
     * and is not extending any other entity,
     * so this method will only return <code>true</code> if the argument reference and <code>this</code>
     * refer to the same object.
     */
    public boolean equals(Object object)
    {
        if (this == object)
        {
            return true;
        }
        if (!(object instanceof TaxonomicLevel))
        {
            return false;
        }
        final TaxonomicLevel that = (TaxonomicLevel)object;
        if (this.code == null || that.getCode() == null || !this.code.equals(that.getCode()))
        {
            return false;
        }
        return true;
    }

    /**
     * Returns a hash code based on this entity's identifiers.
     */
    public int hashCode()
    {
        int hashCode = 0;
        hashCode = 29 * hashCode + (code == null ? 0 : code.hashCode());

        return hashCode;
    }

    /**
     * Constructs new instances of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel}.
     */
    public static final class Factory
    {
        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel}.
         */
        public static fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel newInstance()
        {
            final fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel entity = new fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevelImpl();
			return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel}, taking all required and/or
         * read-only properties as arguments.
         */
        public static fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel newInstance(java.lang.Integer rank, java.lang.String name, java.util.Date creationDate, fr.ifremer.adagio.core.dao.referential.Status status)
        {
            final fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel entity = newInstance();
            entity.setRank(rank);
            entity.setName(name);
            entity.setCreationDate(creationDate);
            entity.setStatus(status);
            return entity;
        }

        /**
         * Constructs a new instance of {@link fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel}, taking all possible properties
         * (except the identifier(s))as arguments.
         */
        public static fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel newInstance(java.lang.Integer rank, java.lang.String name, java.lang.String label, java.lang.String comments, java.util.Date creationDate, java.sql.Timestamp updateDate, fr.ifremer.adagio.core.dao.referential.Status status, java.util.Collection<fr.ifremer.adagio.core.dao.referential.taxon.TaxonName> taxonNames)
        {
            final fr.ifremer.adagio.core.dao.referential.taxon.TaxonomicLevel entity = newInstance();
            entity.setRank(rank);
            entity.setName(name);
            entity.setLabel(label);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setUpdateDate(updateDate);
            entity.setStatus(status);
            entity.setTaxonNames(taxonNames);
            return entity;
        }
    }
    
// HibernateEntity.vsl merge-point
}