package fr.ifremer.adagio.core.dao.referential.taxon;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.StatusImpl;

/**
 * @see fr.ifremer.adagio.core.dao.referential.taxon.TaxonName
 */
@Repository("taxonNameDao")
public class TaxonNameDaoImpl
    extends fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameDaoBase
    implements TaxonNameExtendDao
{

    private static final String QUERY_ALL_TAXON_REFTAX = "selectAllTaxonRefTax";

    private static final String QUERY_TAXON_REFTAX = "selectTaxonRefTax";

    private static final Pattern COMMENT_PATTERN = Pattern.compile(
            "([A-Z0-9]+)(?: - .*)?");

    /**
     * Constructor used by Spring
     */
	@Autowired
	public TaxonNameDaoImpl(org.hibernate.SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}

    @Override
    public TaxonRefTaxVO[] getAllTaxonRefTax() {
        logger.debug("call getAllValidTaxonNameWithRefTaxCode()"); //$NON-NLS-1$
        try {

            Session session = getSession(false);

            Query query = session.getNamedQuery(QUERY_ALL_TAXON_REFTAX);

            List<TaxonRefTaxVO> results = new ArrayList<TaxonRefTaxVO>();
            for (@SuppressWarnings("unchecked")
                 Iterator<Object[]> iterator = query.iterate(); iterator.hasNext(); ) {
                Object[] cols = iterator.next();
                TaxonRefTaxVO taxonNameRefTaxVO = loadTaxon(cols);
                results.add(taxonNameRefTaxVO);
            }
            if (results.size() == 0) {
                return null;
            }

            // Return the first element in the list
            return results.toArray(new TaxonRefTaxVO[results.size()]);
        } catch (RuntimeException re) {
            logger.error("getLocationIdByLabelAndLocationLevel failed", re); //$NON-NLS-1$
            throw re;
        }
    }

    @Override
    public TaxonRefTaxVO getTaxonRefTax(Integer taxonId) {
        logger.debug("call getAllValidTaxonNameWithRefTaxCode()"); //$NON-NLS-1$
        try {

            Session session = getSession(false);

            Query query = session.getNamedQuery(QUERY_TAXON_REFTAX);
            query.setInteger("taxonId", taxonId);

            Object[] cols = (Object[]) query.uniqueResult();
            TaxonRefTaxVO taxonNameRefTaxVO = loadTaxon(cols);

            return taxonNameRefTaxVO;
        } catch (RuntimeException re) {
            logger.error("getLocationIdByLabelAndLocationLevel failed", re); //$NON-NLS-1$
            throw re;
        }
    }

    protected TaxonRefTaxVO loadTaxon(Object[] cols) {
        TaxonRefTaxVO result = new TaxonRefTaxVO();
        result.setReferenceTaxonId((Integer) cols[0]);
        result.setName((String) cols[1]);
        String comments = (String) cols[2];
        if (comments != null && comments.length() > 0) {
            Matcher matcher = COMMENT_PATTERN.matcher(comments);
            if (matcher.matches()) {
                String reftaxCode = matcher.group(1);
                result.setRefTaxCode(reftaxCode);
            }
        }
        Boolean tempStatus = (Boolean) cols[3];
        StatusCode status = tempStatus ? StatusCode.TEMPORARY : StatusCode.ENABLE;
        result.setStatus(status);
        return result;
    }
}
