package fr.ifremer.adagio.core.dao.referential.location.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;
import org.springframework.stereotype.Repository;

import fr.ifremer.adagio.core.dao.referential.location.LocationSpecificDao;

@Repository("locationSpecificDao")
public class LocationSpecificDaoImpl extends HibernateDaoSupport implements LocationSpecificDao {
	
	private static final String QUERY_LOCATION_ID_BY_LABEL_AND_LOCATION_LEVEL_IDS = "selectLocationIdByLabelAndLocationLevel";
	

	@Autowired
	public LocationSpecificDaoImpl(SessionFactory sessionFactory) {
		super();
		setSessionFactory(sessionFactory);
	}
	
	@Override
	public String getLocationLabelByLatLong(Float latitude, Float longitude) {
		if (longitude == null || latitude == null) {
			return null;
		}
		String locationLabel = null;
		
		// If position inside "Mediterranean and black sea" :
		if (((longitude >= 0 && longitude < 42) && (latitude >= 30 && latitude < 47.5))
				|| ((longitude >= -6 && longitude < 0) && (latitude >= 35 && latitude < 40))) {
			
			// Number of rectangles, between the given latitude and 30°N :
			double nbdemidegreeLat = Math.floor((latitude - 30)) * 2;
			
			// Number of rectangles, between the given longitude and 6°W :
			double nbdemidegreeLong = Math.floor((longitude + 6)) * 2;
			
			// Letter change every 10 rectangles, starting with 'A' :
			char letter = new Character((char) ((int) (Math.floor(nbdemidegreeLong / 10) + 65))).charValue();
			int rest = (int) (nbdemidegreeLong % 10);
			locationLabel = "M" + String.valueOf((int) nbdemidegreeLat) + letter + String.valueOf(rest); //$NON-NLS-1$
		}
		
		// If position inside "Atlantic (nord-east)" :
		else if ((longitude >= -50 && longitude <= 70) && (latitude >= 36 && latitude <= 89)) {
			int halfDegreesNb = (int) Math.floor((latitude - 36) * 2) + 1;
			double degreesNb = Math.floor(longitude + 50);
			char letter = new Character((char) ((int) (Math.floor(degreesNb / 10) + 65))).charValue();
			int rest = (int) (degreesNb % 10);
			locationLabel = String.valueOf(halfDegreesNb) + letter + String.valueOf(rest);
		}
		return locationLabel;
	}
	@Override
	public Integer getLocationIdByLabelAndLocationLevel(String locationLabel, Integer[] locationLevelIds) {
		logger.debug("call getLocationIdByLabelAndLocationLevel()"); //$NON-NLS-1$
		try {
			Query query = null;
			query = this.getSession(false).getNamedQuery(QUERY_LOCATION_ID_BY_LABEL_AND_LOCATION_LEVEL_IDS);
			query.setString("locationLabel", locationLabel); //$NON-NLS-1$
			query.setParameterList("locationLevelIds", locationLevelIds); //$NON-NLS-1$ //$NON-NLS-1$

			List<Integer> locationIds = new ArrayList<Integer>();
			for (@SuppressWarnings("unchecked")
			Iterator<Integer> iterator = query.iterate(); iterator.hasNext();) {
				Integer locationId = iterator.next();
				locationIds.add(locationId);
			}
			if (locationIds.size() == 0) {
				return null;
			}
			if (locationIds.size() > 1) {
				throw new DataRetrievalFailureException("Too many locations found, for label : " + locationLabel);
			}

			// Return the first element in the list
			return locationIds.get(0);
		} catch (RuntimeException re) {
			logger.error("getLocationIdByLabelAndLocationLevel failed", re); //$NON-NLS-1$
			throw re;
		}
	}

}
