package fr.ifremer.adagio.core.dao.referential.location;

public interface LocationExtendDao extends LocationDao {

	/**
	 * Return location label from a longitude and a latitude (in decimal degrees - WG84).
	 * 
	 * @param latitude a latitude (in decimal degrees - WG84)
	 * @param longitude a longitude (in decimal degrees - WG84)
	 * @return A location label (corresponding to a statistical rectangle), or null if no statistical rectangle exists for this position
	 */
	String getLocationLabelByLatLong(Float latitude, Float longitude);
	
	/**
	 * Return a location Id, from a longitude and a latitude (in decimal degrees - WG84).
	 * This method typically use getLocationLabelByLatLong().
	 * 
	 * @param latitude a latitude (in decimal degrees - WG84)
	 * @param longitude a longitude (in decimal degrees - WG84)
	 * @return A location Id (corresponding to a statistical rectangle), or null if no statistical rectangle exists for this position
	 */
	Integer getLocationIdByLabelAndLocationLevel(String locationLabel, Integer[] locationLevelIds);
}
