//
package fr.ifremer.adagio.core.dao;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

/**
 * Classe utilitaire pour vÃƒÂ©rifier que les valeurs d'ÃƒÂ©numÃƒÂ©ration sont correctement configurÃƒÂ©es.
 */
public class EnumerationsInitializationHelper {

	private static Boolean enumerationsHasErrors = null;

	/**
	 * VÃƒÂ©rifie que les ÃƒÂ©numÃƒÂ©rations sont bien configurÃƒÂ©es via le fichier enumerations.properties. Renvoie
	 * false si l'une
	 * des valeurs d'ÃƒÂ©numÃƒÂ©ration n'est pas correcte (par exemple des caractÃƒÂ¨res alphanumÃƒÂ©riques pour une
	 * valeur de
	 * QualitativeValueId).<br/>
	 * Ne revoie pas false si le fichier properties n'est pas trouvÃƒÂ©, ou s'il ne contient pas toutes les valeurs
	 * d'ÃƒÂ©numÃƒÂ©rations.
	 */
	public static boolean checkEnumerations() {
		/*
		 * Fait appel ÃƒÂ la mÃƒÂ©thode values sur toutes les classes d'ÃƒÂ©numÃƒÂ©ration de faÃƒÂ§on ÃƒÂ les forcer ÃƒÂ
		 * ÃƒÂªtre
		 * initialisÃƒÂ©es.
		 */
		if (enumerationsHasErrors == null) {
			Collection<Class> enumClasses = getEnumsForPackage("fr.ifremer.adagio.core.dao");
			for (Iterator iterator = enumClasses.iterator(); iterator.hasNext();) {
				Class enumClazz = (Class) iterator.next();
				try {
					Method hasInitErrorMethod = enumClazz.getMethod("hasInitError", null);
					Method getNameMethod = enumClazz.getMethod("getName", null);
					Object[] enums = enumClazz.getEnumConstants();
					for (int i = 0; i < enums.length; i++) {
						Object aEnum = enums[i];
						Boolean hasInitError = (Boolean)hasInitErrorMethod.invoke(aEnum, null);
						if (hasInitError) {
							enumerationsHasErrors = true;
							break; // for exit
						}
					}
				} catch (Exception e) {
					// skip class
				}	
				if (enumerationsHasErrors != null && enumerationsHasErrors == true) {
					break; // for exit 
				}
			}
			if (enumerationsHasErrors == null) {
				enumerationsHasErrors = false;
			}
		}
		return !enumerationsHasErrors;
	}

	/**
	 * Scans all classloaders for the current thread for loaded jars, and then scans
	 * each jar for the package name in question, listing all classes directly under
	 * the package name in question. Assumes directory structure in jar file and class
	 * package naming follow java conventions (i.e. com.example.test.MyTest would be in
	 * /com/example/test/MyTest.class)
	 */
	public static Collection<Class> getEnumsForPackage(String packageName) {
		String packagePath = packageName.replace(".", "/");
		ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
		Set<Class> classes = new HashSet<Class>();
		getEnumsForPackage(packageName, packagePath, classes, classLoader);
		return classes;
	}

	private static void getEnumsForPackage(String packageName, String packagePath, Set<Class> classes, ClassLoader classLoader) {
		Set<URL> jarUrls = new HashSet<URL>();
		Set<URL> directoryUrls = new HashSet<URL>();

		while (classLoader != null) {
			if (classLoader instanceof URLClassLoader)
				for (URL url : ((URLClassLoader) classLoader).getURLs())
					if (url.getFile().endsWith(".jar")) { // may want better way to detect jar files
						jarUrls.add(url);
					}
					else {
						directoryUrls.add(url);
					}

			classLoader = classLoader.getParent();
		}

		// Analyze unpacked classes directories
		for (URL url : directoryUrls) {			
			try {
				File  directory = new File(url.toURI());
				getEnumsForPackage(packagePath, classes, new File(directory, packagePath));
			} catch (URISyntaxException e1) {
				// skip
			} 
		}
		
		// Analyze Jar 
		for (URL url : jarUrls) {
			JarInputStream stream = null;
			try {
				stream = new JarInputStream(url.openStream()); // may want better way to open url connections
				JarEntry entry = stream.getNextJarEntry();

				while (entry != null) {
					String name = entry.getName();
					if (name.startsWith(packagePath+"/") && name.endsWith(".class"))
						try {
							Class clazz = Class.forName(name.substring(0, name.length() - 6).replace("/", "."));
							if (clazz.isEnum()) {
								classes.add(clazz);
							}
						} catch (ClassNotFoundException e) {
							// skip class
						}
					entry = stream.getNextJarEntry();
				}
			} catch (IOException e) {
				// Skip
			} 
			finally {
				if (stream != null) {
					try {
						stream.close();
					} catch (IOException e) {
						// Nothing to do
					}
				}
			}			
		}
	}
	
	private static void getEnumsForPackage(String packagePath, Set<Class> classes, File packageDirectory) {
		if (!packageDirectory.isDirectory()) {
			return;
		}

		// Get the list of the files contained in the package
		String[] files = packageDirectory.list();
		for (int i = 0; i < files.length; i++) {
			// we are only interested in .class files
			if (files[i].endsWith(".class")) {
				String name = packagePath + "/" + files[i];
				try {
					// removes the .class extension
					Class clazz = Class.forName(name.substring(0, name.length() - 6).replace("/", "."));
					if (clazz.isEnum()) {
						classes.add(clazz);
					}
				} catch (ClassNotFoundException e) {
					// Nothing to do : just skip this class
				}				
			}
			// trying in child
			else {
				getEnumsForPackage(packagePath + "/" + files[i], classes, new File(packageDirectory, files[i]));
			}
		}
	}

}