/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.service;

import fr.ifremer.adagio.core.service.referential.location.LocationService;
import org.springframework.beans.factory.access.BeanFactoryLocator;
import org.springframework.beans.factory.access.BeanFactoryReference;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.AbstractApplicationContext;

public class ServiceLocator {
    private static final String DEFAULT_BEAN_REFERENCE_LOCATION = "beanRefFactory.xml";
    private static final String DEFAULT_BEAN_REFERENCE_ID = "beanRefFactory";
    private static final ServiceLocator instance = new ServiceLocator();
    private BeanFactoryReference beanFactoryReference;
    private String beanFactoryReferenceLocation;
    private String beanRefFactoryReferenceId;

    protected ServiceLocator() {
        this.init(null, null);
    }

    protected ServiceLocator(String beanFactoryReferenceLocation, String beanRefFactoryReferenceId) {
        this.init(beanFactoryReferenceLocation, beanRefFactoryReferenceId);
    }

    public static ServiceLocator instance() {
        return instance;
    }

    public synchronized void init(String beanFactoryReferenceLocation, String beanRefFactoryReferenceId) {
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation == null ? DEFAULT_BEAN_REFERENCE_LOCATION : beanFactoryReferenceLocation;
        this.beanRefFactoryReferenceId = beanRefFactoryReferenceId == null ? DEFAULT_BEAN_REFERENCE_ID : beanRefFactoryReferenceId;
        this.beanFactoryReference = null;
    }

    public synchronized void init(String beanFactoryReferenceLocation) {
        this.beanFactoryReferenceLocation = beanFactoryReferenceLocation == null ? DEFAULT_BEAN_REFERENCE_LOCATION : beanFactoryReferenceLocation;
        this.beanFactoryReference = null;
    }

    public synchronized void shutdown() {
        ((AbstractApplicationContext)this.getContext()).close();
        if (this.beanFactoryReference != null) {
            this.beanFactoryReference.release();
            this.beanFactoryReference = null;
        }
    }

    public <S> S getService(String name, Class<S> serviceType) {
        return (S)this.getContext().getBean(name, serviceType);
    }

    public final LocationService getLocationService() {
        return this.getService("locationService", LocationService.class);
    }

    protected synchronized ApplicationContext getContext() {
        if (this.beanFactoryReference == null) {
            BeanFactoryLocator beanFactoryLocator = ContextSingletonBeanFactoryLocator.getInstance((String)this.beanFactoryReferenceLocation);
            this.beanFactoryReference = beanFactoryLocator.useBeanFactory(this.beanRefFactoryReferenceId);
        }
        return (ApplicationContext)this.beanFactoryReference.getFactory();
    }
}

