/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.technical.optimization.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyException;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyExceptionDao;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyExceptionImpl;
import fr.ifremer.adagio.core.dao.technical.optimization.location.LocationHierarchyExceptionPK;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class LocationHierarchyExceptionDaoBase
extends HibernateDaoSupport
implements LocationHierarchyExceptionDao {
    @Override
    public Object load(int transform, Location parent, Location location) {
        LocationHierarchyExceptionPK entityPk = new LocationHierarchyExceptionPK();
        if (parent == null) {
            throw new IllegalArgumentException("LocationHierarchyException.load - 'parent' can not be null");
        }
        if (location == null) {
            throw new IllegalArgumentException("LocationHierarchyException.load - 'location' can not be null");
        }
        entityPk.setParent(parent);
        entityPk.setLocation(location);
        Object entity = this.getHibernateTemplate().get(LocationHierarchyExceptionImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LocationHierarchyException)entity);
    }

    @Override
    public LocationHierarchyException load(Location parent, Location location) {
        return (LocationHierarchyException)this.load(0, parent, location);
    }

    @Override
    public Collection<LocationHierarchyException> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationHierarchyExceptionImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LocationHierarchyException create(LocationHierarchyException locationHierarchyException) {
        return (LocationHierarchyException)this.create(0, locationHierarchyException);
    }

    @Override
    public Object create(int transform, LocationHierarchyException locationHierarchyException) {
        if (locationHierarchyException == null) {
            throw new IllegalArgumentException("LocationHierarchyException.create - 'locationHierarchyException' can not be null");
        }
        this.getHibernateTemplate().save((Object)locationHierarchyException);
        return this.transformEntity(transform, locationHierarchyException);
    }

    @Override
    public Collection<LocationHierarchyException> create(Collection<LocationHierarchyException> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LocationHierarchyException> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationHierarchyException.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationHierarchyExceptionDaoBase.this.create(transform, (LocationHierarchyException)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LocationHierarchyException create(Float childSurfaceRatio, Location parent, Location location) {
        return (LocationHierarchyException)this.create(0, childSurfaceRatio, parent, location);
    }

    @Override
    public Object create(int transform, Float childSurfaceRatio, Location parent, Location location) {
        LocationHierarchyExceptionImpl entity = new LocationHierarchyExceptionImpl();
        LocationHierarchyExceptionPK entityPk = new LocationHierarchyExceptionPK();
        entity.setLocationHierarchyExceptionPk(entityPk);
        entity.setChildSurfaceRatio(childSurfaceRatio);
        entityPk.setParent(parent);
        entityPk.setLocation(location);
        return this.create(transform, entity);
    }

    @Override
    public void update(LocationHierarchyException locationHierarchyException) {
        if (locationHierarchyException == null) {
            throw new IllegalArgumentException("LocationHierarchyException.update - 'locationHierarchyException' can not be null");
        }
        this.getHibernateTemplate().update((Object)locationHierarchyException);
    }

    @Override
    public void update(final Collection<LocationHierarchyException> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationHierarchyException.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationHierarchyExceptionDaoBase.this.update((LocationHierarchyException)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LocationHierarchyException locationHierarchyException) {
        if (locationHierarchyException == null) {
            throw new IllegalArgumentException("LocationHierarchyException.remove - 'locationHierarchyException' can not be null");
        }
        this.getHibernateTemplate().delete((Object)locationHierarchyException);
    }

    @Override
    public void remove(Location parent, Location location) {
        LocationHierarchyExceptionPK entityPk = new LocationHierarchyExceptionPK();
        if (parent == null) {
            throw new IllegalArgumentException("LocationHierarchyException.remove - 'parent' can not be null");
        }
        entityPk.setParent(parent);
        if (location == null) {
            throw new IllegalArgumentException("LocationHierarchyException.remove - 'location' can not be null");
        }
        entityPk.setLocation(location);
        LocationHierarchyException entity = this.load(parent, location);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LocationHierarchyException> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationHierarchyException.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LocationHierarchyException entity) {
        LocationHierarchyException target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LocationHierarchyException toEntity(Object[] row) {
        LocationHierarchyException target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LocationHierarchyException)) continue;
                target = (LocationHierarchyException)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationHierarchyExceptionImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationHierarchyExceptionImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LocationHierarchyException> search(Search search) {
        return this.search(0, search);
    }
}

