/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.vessel;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriod;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriodDao;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriodImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriodPK;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class VesselRegistrationPeriodDaoBase
extends HibernateDaoSupport
implements VesselRegistrationPeriodDao {
    @Override
    public Object load(int transform, Date startDateTime, Vessel vessel, Location registrationLocation) {
        VesselRegistrationPeriodPK entityPk = new VesselRegistrationPeriodPK();
        if (startDateTime == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.load - 'startDateTime' can not be null");
        }
        if (vessel == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.load - 'vessel' can not be null");
        }
        if (registrationLocation == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.load - 'registrationLocation' can not be null");
        }
        entityPk.setStartDateTime(startDateTime);
        entityPk.setVessel(vessel);
        entityPk.setRegistrationLocation(registrationLocation);
        Object entity = this.getHibernateTemplate().get(VesselRegistrationPeriodImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (VesselRegistrationPeriod)entity);
    }

    @Override
    public VesselRegistrationPeriod load(Date startDateTime, Vessel vessel, Location registrationLocation) {
        return (VesselRegistrationPeriod)this.load(0, startDateTime, vessel, registrationLocation);
    }

    @Override
    public Collection<VesselRegistrationPeriod> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(VesselRegistrationPeriodImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public VesselRegistrationPeriod create(VesselRegistrationPeriod vesselRegistrationPeriod) {
        return (VesselRegistrationPeriod)this.create(0, vesselRegistrationPeriod);
    }

    @Override
    public Object create(int transform, VesselRegistrationPeriod vesselRegistrationPeriod) {
        if (vesselRegistrationPeriod == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.create - 'vesselRegistrationPeriod' can not be null");
        }
        this.getHibernateTemplate().save((Object)vesselRegistrationPeriod);
        return this.transformEntity(transform, vesselRegistrationPeriod);
    }

    @Override
    public Collection<VesselRegistrationPeriod> create(Collection<VesselRegistrationPeriod> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<VesselRegistrationPeriod> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VesselRegistrationPeriodDaoBase.this.create(transform, (VesselRegistrationPeriod)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public VesselRegistrationPeriod create(Date startDateTime, Date endDateTime, String registrationCode, String internationalRegistrationCode, Vessel vessel, Location registrationLocation) {
        return (VesselRegistrationPeriod)this.create(0, startDateTime, endDateTime, registrationCode, internationalRegistrationCode, vessel, registrationLocation);
    }

    @Override
    public Object create(int transform, Date startDateTime, Date endDateTime, String registrationCode, String internationalRegistrationCode, Vessel vessel, Location registrationLocation) {
        VesselRegistrationPeriodImpl entity = new VesselRegistrationPeriodImpl();
        VesselRegistrationPeriodPK entityPk = new VesselRegistrationPeriodPK();
        entity.setVesselRegistrationPeriodPk(entityPk);
        entityPk.setStartDateTime(startDateTime);
        entity.setEndDateTime(endDateTime);
        entity.setRegistrationCode(registrationCode);
        entity.setInternationalRegistrationCode(internationalRegistrationCode);
        entityPk.setVessel(vessel);
        entityPk.setRegistrationLocation(registrationLocation);
        return this.create(transform, entity);
    }

    @Override
    public VesselRegistrationPeriod create(Location registrationLocation, Date startDateTime, Vessel vessel) {
        return (VesselRegistrationPeriod)this.create(0, registrationLocation, startDateTime, vessel);
    }

    @Override
    public Object create(int transform, Location registrationLocation, Date startDateTime, Vessel vessel) {
        VesselRegistrationPeriodImpl entity = new VesselRegistrationPeriodImpl();
        VesselRegistrationPeriodPK entityPk = new VesselRegistrationPeriodPK();
        entity.setVesselRegistrationPeriodPk(entityPk);
        entityPk.setRegistrationLocation(registrationLocation);
        entityPk.setStartDateTime(startDateTime);
        entityPk.setVessel(vessel);
        return this.create(transform, entity);
    }

    @Override
    public void update(VesselRegistrationPeriod vesselRegistrationPeriod) {
        if (vesselRegistrationPeriod == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.update - 'vesselRegistrationPeriod' can not be null");
        }
        this.getHibernateTemplate().update((Object)vesselRegistrationPeriod);
    }

    @Override
    public void update(final Collection<VesselRegistrationPeriod> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    VesselRegistrationPeriodDaoBase.this.update((VesselRegistrationPeriod)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(VesselRegistrationPeriod vesselRegistrationPeriod) {
        if (vesselRegistrationPeriod == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.remove - 'vesselRegistrationPeriod' can not be null");
        }
        this.getHibernateTemplate().delete((Object)vesselRegistrationPeriod);
    }

    @Override
    public void remove(Date startDateTime, Vessel vessel, Location registrationLocation) {
        VesselRegistrationPeriodPK entityPk = new VesselRegistrationPeriodPK();
        if (startDateTime == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.remove - 'startDateTime' can not be null");
        }
        entityPk.setStartDateTime(startDateTime);
        if (vessel == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.remove - 'vessel' can not be null");
        }
        entityPk.setVessel(vessel);
        if (registrationLocation == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.remove - 'registrationLocation' can not be null");
        }
        entityPk.setRegistrationLocation(registrationLocation);
        VesselRegistrationPeriod entity = this.load(startDateTime, vessel, registrationLocation);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<VesselRegistrationPeriod> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("VesselRegistrationPeriod.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, VesselRegistrationPeriod entity) {
        VesselRegistrationPeriod target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected VesselRegistrationPeriod toEntity(Object[] row) {
        VesselRegistrationPeriod target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof VesselRegistrationPeriod)) continue;
                target = (VesselRegistrationPeriod)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VesselRegistrationPeriodImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), VesselRegistrationPeriodImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<VesselRegistrationPeriod> search(Search search) {
        return this.search(0, search);
    }
}

