/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.vessel;

import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.VesselType;
import fr.ifremer.adagio.core.dao.referential.regulation.RightToProduce;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselFeatures;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselImpl;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselMasterPeriod;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselOwnerPeriod;
import fr.ifremer.adagio.core.dao.referential.vessel.VesselRegistrationPeriod;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashSet;

public abstract class Vessel
implements Serializable {
    private static final long serialVersionUID = -6166084732904526931L;
    private String code;
    private Timestamp updateDate;
    private Collection<RightToProduce> rightToProduces = new HashSet<RightToProduce>();
    private VesselType vesselType;
    private Collection<VesselFeatures> vesselFeatures = new HashSet<VesselFeatures>();
    private Collection<VesselRegistrationPeriod> vesselRegistrationPeriods = new HashSet<VesselRegistrationPeriod>();
    private Collection<VesselOwnerPeriod> vesselOwnerPeriods = new HashSet<VesselOwnerPeriod>();
    private Collection<VesselMasterPeriod> vesselMasterPeriods = new HashSet<VesselMasterPeriod>();
    private Status status;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public Collection<RightToProduce> getRightToProduces() {
        return this.rightToProduces;
    }

    public void setRightToProduces(Collection<RightToProduce> rightToProduces) {
        this.rightToProduces = rightToProduces;
    }

    public VesselType getVesselType() {
        return this.vesselType;
    }

    public void setVesselType(VesselType vesselType) {
        this.vesselType = vesselType;
    }

    public Collection<VesselFeatures> getVesselFeatures() {
        return this.vesselFeatures;
    }

    public void setVesselFeatures(Collection<VesselFeatures> vesselFeatures) {
        this.vesselFeatures = vesselFeatures;
    }

    public Collection<VesselRegistrationPeriod> getVesselRegistrationPeriods() {
        return this.vesselRegistrationPeriods;
    }

    public void setVesselRegistrationPeriods(Collection<VesselRegistrationPeriod> vesselRegistrationPeriods) {
        this.vesselRegistrationPeriods = vesselRegistrationPeriods;
    }

    public Collection<VesselOwnerPeriod> getVesselOwnerPeriods() {
        return this.vesselOwnerPeriods;
    }

    public void setVesselOwnerPeriods(Collection<VesselOwnerPeriod> vesselOwnerPeriods) {
        this.vesselOwnerPeriods = vesselOwnerPeriods;
    }

    public Collection<VesselMasterPeriod> getVesselMasterPeriods() {
        return this.vesselMasterPeriods;
    }

    public void setVesselMasterPeriods(Collection<VesselMasterPeriod> vesselMasterPeriods) {
        this.vesselMasterPeriods = vesselMasterPeriods;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Vessel)) {
            return false;
        }
        Vessel that = (Vessel)object;
        return this.code != null && that.getCode() != null && this.code.equals(that.getCode());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.code == null ? 0 : this.code.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Vessel newInstance() {
            VesselImpl entity = new VesselImpl();
            return entity;
        }

        public static Vessel newInstance(VesselType vesselType, Status status) {
            Vessel entity = Factory.newInstance();
            entity.setVesselType(vesselType);
            entity.setStatus(status);
            return entity;
        }

        public static Vessel newInstance(Timestamp updateDate, Collection<RightToProduce> rightToProduces, VesselType vesselType, Collection<VesselFeatures> vesselFeatures, Collection<VesselRegistrationPeriod> vesselRegistrationPeriods, Collection<VesselOwnerPeriod> vesselOwnerPeriods, Collection<VesselMasterPeriod> vesselMasterPeriods, Status status) {
            Vessel entity = Factory.newInstance();
            entity.setUpdateDate(updateDate);
            entity.setRightToProduces(rightToProduces);
            entity.setVesselType(vesselType);
            entity.setVesselFeatures(vesselFeatures);
            entity.setVesselRegistrationPeriods(vesselRegistrationPeriods);
            entity.setVesselOwnerPeriods(vesselOwnerPeriods);
            entity.setVesselMasterPeriods(vesselMasterPeriods);
            entity.setStatus(status);
            return entity;
        }
    }
}

