/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.referential.StatusCode;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameDaoBase;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameExtendDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefTaxVO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="taxonNameDao")
public class TaxonNameDaoImpl
extends TaxonNameDaoBase
implements TaxonNameExtendDao {
    private static final String QUERY_ALL_TAXON_REFTAX = "selectAllTaxonRefTax";
    private static final String QUERY_TAXON_REFTAX = "selectTaxonRefTax";
    private static final Pattern COMMENT_PATTERN = Pattern.compile("([A-Z0-9]+)(?: - .*)?");

    @Autowired
    public TaxonNameDaoImpl(SessionFactory sessionFactory) {
        this.setSessionFactory(sessionFactory);
    }

    @Override
    public TaxonRefTaxVO[] getAllTaxonRefTax() {
        this.logger.debug((Object)"call getAllValidTaxonNameWithRefTaxCode()");
        try {
            Session session = this.getSession(false);
            Query query = session.getNamedQuery(QUERY_ALL_TAXON_REFTAX);
            ArrayList<TaxonRefTaxVO> results = new ArrayList<TaxonRefTaxVO>();
            Iterator iterator = query.iterate();
            while (iterator.hasNext()) {
                Object[] cols = (Object[])iterator.next();
                TaxonRefTaxVO taxonNameRefTaxVO = this.loadTaxon(cols);
                results.add(taxonNameRefTaxVO);
            }
            if (results.size() == 0) {
                return null;
            }
            return results.toArray(new TaxonRefTaxVO[results.size()]);
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"getLocationIdByLabelAndLocationLevel failed", (Throwable)re);
            throw re;
        }
    }

    @Override
    public TaxonRefTaxVO getTaxonRefTax(Integer taxonId) {
        this.logger.debug((Object)"call getAllValidTaxonNameWithRefTaxCode()");
        try {
            Session session = this.getSession(false);
            Query query = session.getNamedQuery(QUERY_TAXON_REFTAX);
            query.setInteger("taxonId", taxonId.intValue());
            Object[] cols = (Object[])query.uniqueResult();
            TaxonRefTaxVO taxonNameRefTaxVO = this.loadTaxon(cols);
            return taxonNameRefTaxVO;
        }
        catch (RuntimeException re) {
            this.logger.error((Object)"getLocationIdByLabelAndLocationLevel failed", (Throwable)re);
            throw re;
        }
    }

    protected TaxonRefTaxVO loadTaxon(Object[] cols) {
        Boolean tempStatus;
        Matcher matcher;
        TaxonRefTaxVO result = new TaxonRefTaxVO();
        result.setReferenceTaxonId((Integer)cols[0]);
        result.setName((String)cols[1]);
        String comments = (String)cols[2];
        if (comments != null && comments.length() > 0 && (matcher = COMMENT_PATTERN.matcher(comments)).matches()) {
            String reftaxCode = matcher.group(1);
            result.setRefTaxCode(reftaxCode);
        }
        StatusCode status = (tempStatus = (Boolean)cols[3]) != false ? StatusCode.TEMPORARY : StatusCode.ENABLE;
        result.setStatus(status);
        return result;
    }
}

