/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocument;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformation;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonInformationPK;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class TaxonInformationDaoBase
extends HibernateDaoSupport
implements TaxonInformationDao {
    @Override
    public Object load(int transform, TaxonName taxonName, ReferenceDocument referenceDocument) {
        TaxonInformationPK entityPk = new TaxonInformationPK();
        if (taxonName == null) {
            throw new IllegalArgumentException("TaxonInformation.load - 'taxonName' can not be null");
        }
        if (referenceDocument == null) {
            throw new IllegalArgumentException("TaxonInformation.load - 'referenceDocument' can not be null");
        }
        entityPk.setTaxonName(taxonName);
        entityPk.setReferenceDocument(referenceDocument);
        Object entity = this.getHibernateTemplate().get(TaxonInformationImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (TaxonInformation)entity);
    }

    @Override
    public TaxonInformation load(TaxonName taxonName, ReferenceDocument referenceDocument) {
        return (TaxonInformation)this.load(0, taxonName, referenceDocument);
    }

    @Override
    public Collection<TaxonInformation> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonInformationImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonInformation create(TaxonInformation taxonInformation) {
        return (TaxonInformation)this.create(0, taxonInformation);
    }

    @Override
    public Object create(int transform, TaxonInformation taxonInformation) {
        if (taxonInformation == null) {
            throw new IllegalArgumentException("TaxonInformation.create - 'taxonInformation' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonInformation);
        return this.transformEntity(transform, taxonInformation);
    }

    @Override
    public Collection<TaxonInformation> create(Collection<TaxonInformation> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonInformation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonInformation.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonInformationDaoBase.this.create(transform, (TaxonInformation)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonInformation create(String description, Timestamp updateDate, TaxonName taxonName, ReferenceDocument referenceDocument) {
        return (TaxonInformation)this.create(0, description, updateDate, taxonName, referenceDocument);
    }

    @Override
    public Object create(int transform, String description, Timestamp updateDate, TaxonName taxonName, ReferenceDocument referenceDocument) {
        TaxonInformationImpl entity = new TaxonInformationImpl();
        TaxonInformationPK entityPk = new TaxonInformationPK();
        entity.setTaxonInformationPk(entityPk);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entityPk.setTaxonName(taxonName);
        entityPk.setReferenceDocument(referenceDocument);
        return this.create(transform, entity);
    }

    @Override
    public TaxonInformation create(ReferenceDocument referenceDocument, TaxonName taxonName) {
        return (TaxonInformation)this.create(0, referenceDocument, taxonName);
    }

    @Override
    public Object create(int transform, ReferenceDocument referenceDocument, TaxonName taxonName) {
        TaxonInformationImpl entity = new TaxonInformationImpl();
        TaxonInformationPK entityPk = new TaxonInformationPK();
        entity.setTaxonInformationPk(entityPk);
        entityPk.setReferenceDocument(referenceDocument);
        entityPk.setTaxonName(taxonName);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonInformation taxonInformation) {
        if (taxonInformation == null) {
            throw new IllegalArgumentException("TaxonInformation.update - 'taxonInformation' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonInformation);
    }

    @Override
    public void update(final Collection<TaxonInformation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonInformation.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonInformationDaoBase.this.update((TaxonInformation)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonInformation taxonInformation) {
        if (taxonInformation == null) {
            throw new IllegalArgumentException("TaxonInformation.remove - 'taxonInformation' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonInformation);
    }

    @Override
    public void remove(TaxonName taxonName, ReferenceDocument referenceDocument) {
        TaxonInformationPK entityPk = new TaxonInformationPK();
        if (taxonName == null) {
            throw new IllegalArgumentException("TaxonInformation.remove - 'taxonName' can not be null");
        }
        entityPk.setTaxonName(taxonName);
        if (referenceDocument == null) {
            throw new IllegalArgumentException("TaxonInformation.remove - 'referenceDocument' can not be null");
        }
        entityPk.setReferenceDocument(referenceDocument);
        TaxonInformation entity = this.load(taxonName, referenceDocument);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonInformation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonInformation.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonInformation entity) {
        TaxonInformation target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonInformation toEntity(Object[] row) {
        TaxonInformation target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonInformation)) continue;
                target = (TaxonInformation)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonInformationImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonInformationImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonInformation> search(Search search) {
        return this.search(0, search);
    }
}

