/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.taxon;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceDocument;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformation;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformationDao;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformationImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupInformationPK;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class TaxonGroupInformationDaoBase
extends HibernateDaoSupport
implements TaxonGroupInformationDao {
    @Override
    public Object load(int transform, TaxonGroup taxonGroup, ReferenceDocument referenceDocument) {
        TaxonGroupInformationPK entityPk = new TaxonGroupInformationPK();
        if (taxonGroup == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.load - 'taxonGroup' can not be null");
        }
        if (referenceDocument == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.load - 'referenceDocument' can not be null");
        }
        entityPk.setTaxonGroup(taxonGroup);
        entityPk.setReferenceDocument(referenceDocument);
        Object entity = this.getHibernateTemplate().get(TaxonGroupInformationImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (TaxonGroupInformation)entity);
    }

    @Override
    public TaxonGroupInformation load(TaxonGroup taxonGroup, ReferenceDocument referenceDocument) {
        return (TaxonGroupInformation)this.load(0, taxonGroup, referenceDocument);
    }

    @Override
    public Collection<TaxonGroupInformation> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TaxonGroupInformationImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public TaxonGroupInformation create(TaxonGroupInformation taxonGroupInformation) {
        return (TaxonGroupInformation)this.create(0, taxonGroupInformation);
    }

    @Override
    public Object create(int transform, TaxonGroupInformation taxonGroupInformation) {
        if (taxonGroupInformation == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.create - 'taxonGroupInformation' can not be null");
        }
        this.getHibernateTemplate().save((Object)taxonGroupInformation);
        return this.transformEntity(transform, taxonGroupInformation);
    }

    @Override
    public Collection<TaxonGroupInformation> create(Collection<TaxonGroupInformation> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<TaxonGroupInformation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonGroupInformationDaoBase.this.create(transform, (TaxonGroupInformation)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public TaxonGroupInformation create(String description, Timestamp updateDate, TaxonGroup taxonGroup, ReferenceDocument referenceDocument) {
        return (TaxonGroupInformation)this.create(0, description, updateDate, taxonGroup, referenceDocument);
    }

    @Override
    public Object create(int transform, String description, Timestamp updateDate, TaxonGroup taxonGroup, ReferenceDocument referenceDocument) {
        TaxonGroupInformationImpl entity = new TaxonGroupInformationImpl();
        TaxonGroupInformationPK entityPk = new TaxonGroupInformationPK();
        entity.setTaxonGroupInformationPk(entityPk);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entityPk.setTaxonGroup(taxonGroup);
        entityPk.setReferenceDocument(referenceDocument);
        return this.create(transform, entity);
    }

    @Override
    public TaxonGroupInformation create(ReferenceDocument referenceDocument, TaxonGroup taxonGroup) {
        return (TaxonGroupInformation)this.create(0, referenceDocument, taxonGroup);
    }

    @Override
    public Object create(int transform, ReferenceDocument referenceDocument, TaxonGroup taxonGroup) {
        TaxonGroupInformationImpl entity = new TaxonGroupInformationImpl();
        TaxonGroupInformationPK entityPk = new TaxonGroupInformationPK();
        entity.setTaxonGroupInformationPk(entityPk);
        entityPk.setReferenceDocument(referenceDocument);
        entityPk.setTaxonGroup(taxonGroup);
        return this.create(transform, entity);
    }

    @Override
    public void update(TaxonGroupInformation taxonGroupInformation) {
        if (taxonGroupInformation == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.update - 'taxonGroupInformation' can not be null");
        }
        this.getHibernateTemplate().update((Object)taxonGroupInformation);
    }

    @Override
    public void update(final Collection<TaxonGroupInformation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TaxonGroupInformationDaoBase.this.update((TaxonGroupInformation)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(TaxonGroupInformation taxonGroupInformation) {
        if (taxonGroupInformation == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.remove - 'taxonGroupInformation' can not be null");
        }
        this.getHibernateTemplate().delete((Object)taxonGroupInformation);
    }

    @Override
    public void remove(TaxonGroup taxonGroup, ReferenceDocument referenceDocument) {
        TaxonGroupInformationPK entityPk = new TaxonGroupInformationPK();
        if (taxonGroup == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.remove - 'taxonGroup' can not be null");
        }
        entityPk.setTaxonGroup(taxonGroup);
        if (referenceDocument == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.remove - 'referenceDocument' can not be null");
        }
        entityPk.setReferenceDocument(referenceDocument);
        TaxonGroupInformation entity = this.load(taxonGroup, referenceDocument);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<TaxonGroupInformation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("TaxonGroupInformation.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, TaxonGroupInformation entity) {
        TaxonGroupInformation target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected TaxonGroupInformation toEntity(Object[] row) {
        TaxonGroupInformation target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof TaxonGroupInformation)) continue;
                target = (TaxonGroupInformation)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonGroupInformationImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TaxonGroupInformationImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<TaxonGroupInformation> search(Search search) {
        return this.search(0, search);
    }
}

