/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.regulation;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.regulation.Corpus;
import fr.ifremer.adagio.core.dao.referential.regulation.Fishery;
import fr.ifremer.adagio.core.dao.referential.regulation.FisheryDao;
import fr.ifremer.adagio.core.dao.referential.regulation.FisheryImpl;
import fr.ifremer.adagio.core.dao.referential.regulation.RegulationArea;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class FisheryDaoBase
extends HibernateDaoSupport
implements FisheryDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Fishery.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(FisheryImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Fishery)entity);
    }

    @Override
    public Fishery load(Integer id) {
        return (Fishery)this.load(0, id);
    }

    @Override
    public Collection<Fishery> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(FisheryImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Fishery create(Fishery fishery) {
        return (Fishery)this.create(0, fishery);
    }

    @Override
    public Object create(int transform, Fishery fishery) {
        if (fishery == null) {
            throw new IllegalArgumentException("Fishery.create - 'fishery' can not be null");
        }
        this.getHibernateTemplate().save((Object)fishery);
        return this.transformEntity(transform, fishery);
    }

    @Override
    public Collection<Fishery> create(Collection<Fishery> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Fishery> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Fishery.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    FisheryDaoBase.this.create(transform, (Fishery)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Fishery create(String name, Timestamp updateDate, RegulationArea regulationArea, Collection<Corpus> corpus, Gear gear, TaxonGroup taxonGroup) {
        return (Fishery)this.create(0, name, updateDate, regulationArea, corpus, gear, taxonGroup);
    }

    @Override
    public Object create(int transform, String name, Timestamp updateDate, RegulationArea regulationArea, Collection<Corpus> corpus, Gear gear, TaxonGroup taxonGroup) {
        FisheryImpl entity = new FisheryImpl();
        entity.setName(name);
        entity.setUpdateDate(updateDate);
        entity.setRegulationArea(regulationArea);
        entity.setCorpus(corpus);
        entity.setGear(gear);
        entity.setTaxonGroup(taxonGroup);
        return this.create(transform, entity);
    }

    @Override
    public Fishery create(String name) {
        return (Fishery)this.create(0, name);
    }

    @Override
    public Object create(int transform, String name) {
        FisheryImpl entity = new FisheryImpl();
        entity.setName(name);
        return this.create(transform, entity);
    }

    @Override
    public void update(Fishery fishery) {
        if (fishery == null) {
            throw new IllegalArgumentException("Fishery.update - 'fishery' can not be null");
        }
        this.getHibernateTemplate().update((Object)fishery);
    }

    @Override
    public void update(final Collection<Fishery> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Fishery.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    FisheryDaoBase.this.update((Fishery)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Fishery fishery) {
        if (fishery == null) {
            throw new IllegalArgumentException("Fishery.remove - 'fishery' can not be null");
        }
        this.getHibernateTemplate().delete((Object)fishery);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Fishery.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Fishery entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Fishery> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Fishery.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Fishery entity) {
        Fishery target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Fishery toEntity(Object[] row) {
        Fishery target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Fishery)) continue;
                target = (Fishery)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), FisheryImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), FisheryImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Fishery> search(Search search) {
        return this.search(0, search);
    }
}

