/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.order;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.order.OrderItem;
import fr.ifremer.adagio.core.dao.referential.order.OrderType;
import fr.ifremer.adagio.core.dao.referential.order.OrderTypeDao;
import fr.ifremer.adagio.core.dao.referential.order.OrderTypeImpl;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class OrderTypeDaoBase
extends HibernateDaoSupport
implements OrderTypeDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("OrderType.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(OrderTypeImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (OrderType)entity);
    }

    @Override
    public OrderType load(Integer id) {
        return (OrderType)this.load(0, id);
    }

    @Override
    public Collection<OrderType> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(OrderTypeImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public OrderType create(OrderType orderType) {
        return (OrderType)this.create(0, orderType);
    }

    @Override
    public Object create(int transform, OrderType orderType) {
        if (orderType == null) {
            throw new IllegalArgumentException("OrderType.create - 'orderType' can not be null");
        }
        this.getHibernateTemplate().save((Object)orderType);
        return this.transformEntity(transform, orderType);
    }

    @Override
    public Collection<OrderType> create(Collection<OrderType> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<OrderType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("OrderType.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    OrderTypeDaoBase.this.create(transform, (OrderType)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public OrderType create(String name, String description, Timestamp updateDate, Collection<OrderItem> orderItems, ObjectType objectType, Status status) {
        return (OrderType)this.create(0, name, description, updateDate, orderItems, objectType, status);
    }

    @Override
    public Object create(int transform, String name, String description, Timestamp updateDate, Collection<OrderItem> orderItems, ObjectType objectType, Status status) {
        OrderTypeImpl entity = new OrderTypeImpl();
        entity.setName(name);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entity.setOrderItems(orderItems);
        entity.setObjectType(objectType);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public OrderType create(String name, ObjectType objectType, Status status) {
        return (OrderType)this.create(0, name, objectType, status);
    }

    @Override
    public Object create(int transform, String name, ObjectType objectType, Status status) {
        OrderTypeImpl entity = new OrderTypeImpl();
        entity.setName(name);
        entity.setObjectType(objectType);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(OrderType orderType) {
        if (orderType == null) {
            throw new IllegalArgumentException("OrderType.update - 'orderType' can not be null");
        }
        this.getHibernateTemplate().update((Object)orderType);
    }

    @Override
    public void update(final Collection<OrderType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("OrderType.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    OrderTypeDaoBase.this.update((OrderType)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(OrderType orderType) {
        if (orderType == null) {
            throw new IllegalArgumentException("OrderType.remove - 'orderType' can not be null");
        }
        this.getHibernateTemplate().delete((Object)orderType);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("OrderType.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        OrderType entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<OrderType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("OrderType.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, OrderType entity) {
        OrderType target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected OrderType toEntity(Object[] row) {
        OrderType target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof OrderType)) continue;
                target = (OrderType)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), OrderTypeImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), OrderTypeImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<OrderType> search(Search search) {
        return this.search(0, search);
    }
}

