/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.metier;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.gear.Gear;
import fr.ifremer.adagio.core.dao.referential.metier.Metier;
import fr.ifremer.adagio.core.dao.referential.metier.MetierDao;
import fr.ifremer.adagio.core.dao.referential.metier.MetierImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class MetierDaoBase
extends HibernateDaoSupport
implements MetierDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Metier.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(MetierImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Metier)entity);
    }

    @Override
    public Metier load(Integer id) {
        return (Metier)this.load(0, id);
    }

    @Override
    public Collection<Metier> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(MetierImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Metier create(Metier metier) {
        return (Metier)this.create(0, metier);
    }

    @Override
    public Object create(int transform, Metier metier) {
        if (metier == null) {
            throw new IllegalArgumentException("Metier.create - 'metier' can not be null");
        }
        this.getHibernateTemplate().save((Object)metier);
        return this.transformEntity(transform, metier);
    }

    @Override
    public Collection<Metier> create(Collection<Metier> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Metier> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Metier.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    MetierDaoBase.this.create(transform, (Metier)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Metier create(String label, String name, String description, Timestamp updateDate, TaxonGroup taxonGroup, Status status, Gear gear) {
        return (Metier)this.create(0, label, name, description, updateDate, taxonGroup, status, gear);
    }

    @Override
    public Object create(int transform, String label, String name, String description, Timestamp updateDate, TaxonGroup taxonGroup, Status status, Gear gear) {
        MetierImpl entity = new MetierImpl();
        entity.setLabel(label);
        entity.setName(name);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entity.setTaxonGroup(taxonGroup);
        entity.setStatus(status);
        entity.setGear(gear);
        return this.create(transform, entity);
    }

    @Override
    public Metier create(String name, Status status) {
        return (Metier)this.create(0, name, status);
    }

    @Override
    public Object create(int transform, String name, Status status) {
        MetierImpl entity = new MetierImpl();
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Metier metier) {
        if (metier == null) {
            throw new IllegalArgumentException("Metier.update - 'metier' can not be null");
        }
        this.getHibernateTemplate().update((Object)metier);
    }

    @Override
    public void update(final Collection<Metier> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Metier.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    MetierDaoBase.this.update((Metier)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Metier metier) {
        if (metier == null) {
            throw new IllegalArgumentException("Metier.remove - 'metier' can not be null");
        }
        this.getHibernateTemplate().delete((Object)metier);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Metier.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Metier entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Metier> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Metier.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Metier entity) {
        Metier target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Metier toEntity(Object[] row) {
        Metier target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Metier)) continue;
                target = (Metier)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), MetierImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), MetierImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Metier> search(Search search) {
        return this.search(0, search);
    }
}

