/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevel;
import fr.ifremer.adagio.core.dao.referential.location.LocationLine;
import fr.ifremer.adagio.core.dao.referential.location.LocationLineDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationLineImpl;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class LocationLineDaoBase
extends HibernateDaoSupport
implements LocationLineDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LocationLine.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(LocationLineImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LocationLine)entity);
    }

    @Override
    public LocationLine load(Integer id) {
        return (LocationLine)this.load(0, id);
    }

    @Override
    public Collection<LocationLine> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationLineImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LocationLine create(LocationLine locationLine) {
        return (LocationLine)this.create(0, locationLine);
    }

    @Override
    public Object create(int transform, LocationLine locationLine) {
        if (locationLine == null) {
            throw new IllegalArgumentException("LocationLine.create - 'locationLine' can not be null");
        }
        this.getHibernateTemplate().save((Object)locationLine);
        return this.transformEntity(transform, locationLine);
    }

    @Override
    public Collection<LocationLine> create(Collection<LocationLine> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LocationLine> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationLine.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationLineDaoBase.this.create(transform, (LocationLine)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LocationLine create(String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, Status status, LocationClassification locationClassification, String position) {
        return (LocationLine)this.create(0, label, name, updateDate, bathymetry, utFormat, daylightSavingTime, locationLevel, status, locationClassification, position);
    }

    @Override
    public Object create(int transform, String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, Status status, LocationClassification locationClassification, String position) {
        LocationLineImpl entity = new LocationLineImpl();
        entity.setLabel(label);
        entity.setName(name);
        entity.setUpdateDate(updateDate);
        entity.setBathymetry(bathymetry);
        entity.setUtFormat(utFormat);
        entity.setDaylightSavingTime(daylightSavingTime);
        entity.setLocationLevel(locationLevel);
        entity.setStatus(status);
        entity.setLocationClassification(locationClassification);
        entity.setPosition(position);
        return this.create(transform, entity);
    }

    @Override
    public LocationLine create(LocationClassification locationClassification, LocationLevel locationLevel, String name, String position, Status status) {
        return (LocationLine)this.create(0, locationClassification, locationLevel, name, position, status);
    }

    @Override
    public Object create(int transform, LocationClassification locationClassification, LocationLevel locationLevel, String name, String position, Status status) {
        LocationLineImpl entity = new LocationLineImpl();
        entity.setLocationClassification(locationClassification);
        entity.setLocationLevel(locationLevel);
        entity.setName(name);
        entity.setPosition(position);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(LocationLine locationLine) {
        if (locationLine == null) {
            throw new IllegalArgumentException("LocationLine.update - 'locationLine' can not be null");
        }
        this.getHibernateTemplate().update((Object)locationLine);
    }

    @Override
    public void update(final Collection<LocationLine> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationLine.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationLineDaoBase.this.update((LocationLine)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LocationLine locationLine) {
        if (locationLine == null) {
            throw new IllegalArgumentException("LocationLine.remove - 'locationLine' can not be null");
        }
        this.getHibernateTemplate().delete((Object)locationLine);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LocationLine.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        LocationLine entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LocationLine> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationLine.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LocationLine entity) {
        LocationLine target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LocationLine toEntity(Object[] row) {
        LocationLine target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LocationLine)) continue;
                target = (LocationLine)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationLineImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationLineImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LocationLine> search(Search search) {
        return this.search(0, search);
    }
}

