/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.location.LocationDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationImpl;
import fr.ifremer.adagio.core.dao.referential.location.LocationLevel;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class LocationDaoBase
extends HibernateDaoSupport
implements LocationDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Location.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(LocationImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Location)entity);
    }

    @Override
    public Location load(Integer id) {
        return (Location)this.load(0, id);
    }

    @Override
    public Collection<Location> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Location create(Location location) {
        return (Location)this.create(0, location);
    }

    @Override
    public Object create(int transform, Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location.create - 'location' can not be null");
        }
        this.getHibernateTemplate().save((Object)location);
        return this.transformEntity(transform, location);
    }

    @Override
    public Collection<Location> create(Collection<Location> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Location> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Location.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationDaoBase.this.create(transform, (Location)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Location create(String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, Status status, LocationClassification locationClassification) {
        return (Location)this.create(0, label, name, updateDate, bathymetry, utFormat, daylightSavingTime, locationLevel, status, locationClassification);
    }

    @Override
    public Object create(int transform, String label, String name, Timestamp updateDate, Float bathymetry, Short utFormat, Boolean daylightSavingTime, LocationLevel locationLevel, Status status, LocationClassification locationClassification) {
        LocationImpl entity = new LocationImpl();
        entity.setLabel(label);
        entity.setName(name);
        entity.setUpdateDate(updateDate);
        entity.setBathymetry(bathymetry);
        entity.setUtFormat(utFormat);
        entity.setDaylightSavingTime(daylightSavingTime);
        entity.setLocationLevel(locationLevel);
        entity.setStatus(status);
        entity.setLocationClassification(locationClassification);
        return this.create(transform, entity);
    }

    @Override
    public Location create(LocationClassification locationClassification, LocationLevel locationLevel, String name, Status status) {
        return (Location)this.create(0, locationClassification, locationLevel, name, status);
    }

    @Override
    public Object create(int transform, LocationClassification locationClassification, LocationLevel locationLevel, String name, Status status) {
        LocationImpl entity = new LocationImpl();
        entity.setLocationClassification(locationClassification);
        entity.setLocationLevel(locationLevel);
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location.update - 'location' can not be null");
        }
        this.getHibernateTemplate().update((Object)location);
    }

    @Override
    public void update(final Collection<Location> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Location.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationDaoBase.this.update((Location)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Location location) {
        if (location == null) {
            throw new IllegalArgumentException("Location.remove - 'location' can not be null");
        }
        this.getHibernateTemplate().delete((Object)location);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Location.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Location entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Location> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Location.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Location entity) {
        Location target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Location toEntity(Object[] row) {
        Location target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Location)) continue;
                target = (Location)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Location> search(Search search) {
        return this.search(0, search);
    }
}

