/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.location;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationAssociation;
import fr.ifremer.adagio.core.dao.referential.location.LocationAssociationDao;
import fr.ifremer.adagio.core.dao.referential.location.LocationAssociationImpl;
import fr.ifremer.adagio.core.dao.referential.location.LocationAssociationPK;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class LocationAssociationDaoBase
extends HibernateDaoSupport
implements LocationAssociationDao {
    @Override
    public Object load(int transform, Location childLocation, Location parentLocation) {
        LocationAssociationPK entityPk = new LocationAssociationPK();
        if (childLocation == null) {
            throw new IllegalArgumentException("LocationAssociation.load - 'childLocation' can not be null");
        }
        if (parentLocation == null) {
            throw new IllegalArgumentException("LocationAssociation.load - 'parentLocation' can not be null");
        }
        entityPk.setChildLocation(childLocation);
        entityPk.setParentLocation(parentLocation);
        Object entity = this.getHibernateTemplate().get(LocationAssociationImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LocationAssociation)entity);
    }

    @Override
    public LocationAssociation load(Location childLocation, Location parentLocation) {
        return (LocationAssociation)this.load(0, childLocation, parentLocation);
    }

    @Override
    public Collection<LocationAssociation> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LocationAssociationImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LocationAssociation create(LocationAssociation locationAssociation) {
        return (LocationAssociation)this.create(0, locationAssociation);
    }

    @Override
    public Object create(int transform, LocationAssociation locationAssociation) {
        if (locationAssociation == null) {
            throw new IllegalArgumentException("LocationAssociation.create - 'locationAssociation' can not be null");
        }
        this.getHibernateTemplate().save((Object)locationAssociation);
        return this.transformEntity(transform, locationAssociation);
    }

    @Override
    public Collection<LocationAssociation> create(Collection<LocationAssociation> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LocationAssociation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationAssociation.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationAssociationDaoBase.this.create(transform, (LocationAssociation)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LocationAssociation create(Float childSurfaceRatio, Timestamp updateDate, Location childLocation, Location parentLocation) {
        return (LocationAssociation)this.create(0, childSurfaceRatio, updateDate, childLocation, parentLocation);
    }

    @Override
    public Object create(int transform, Float childSurfaceRatio, Timestamp updateDate, Location childLocation, Location parentLocation) {
        LocationAssociationImpl entity = new LocationAssociationImpl();
        LocationAssociationPK entityPk = new LocationAssociationPK();
        entity.setLocationAssociationPk(entityPk);
        entity.setChildSurfaceRatio(childSurfaceRatio);
        entity.setUpdateDate(updateDate);
        entityPk.setChildLocation(childLocation);
        entityPk.setParentLocation(parentLocation);
        return this.create(transform, entity);
    }

    @Override
    public LocationAssociation create(Location childLocation, Float childSurfaceRatio, Location parentLocation) {
        return (LocationAssociation)this.create(0, childLocation, childSurfaceRatio, parentLocation);
    }

    @Override
    public Object create(int transform, Location childLocation, Float childSurfaceRatio, Location parentLocation) {
        LocationAssociationImpl entity = new LocationAssociationImpl();
        LocationAssociationPK entityPk = new LocationAssociationPK();
        entity.setLocationAssociationPk(entityPk);
        entityPk.setChildLocation(childLocation);
        entity.setChildSurfaceRatio(childSurfaceRatio);
        entityPk.setParentLocation(parentLocation);
        return this.create(transform, entity);
    }

    @Override
    public void update(LocationAssociation locationAssociation) {
        if (locationAssociation == null) {
            throw new IllegalArgumentException("LocationAssociation.update - 'locationAssociation' can not be null");
        }
        this.getHibernateTemplate().update((Object)locationAssociation);
    }

    @Override
    public void update(final Collection<LocationAssociation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationAssociation.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LocationAssociationDaoBase.this.update((LocationAssociation)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LocationAssociation locationAssociation) {
        if (locationAssociation == null) {
            throw new IllegalArgumentException("LocationAssociation.remove - 'locationAssociation' can not be null");
        }
        this.getHibernateTemplate().delete((Object)locationAssociation);
    }

    @Override
    public void remove(Location childLocation, Location parentLocation) {
        LocationAssociationPK entityPk = new LocationAssociationPK();
        if (childLocation == null) {
            throw new IllegalArgumentException("LocationAssociation.remove - 'childLocation' can not be null");
        }
        entityPk.setChildLocation(childLocation);
        if (parentLocation == null) {
            throw new IllegalArgumentException("LocationAssociation.remove - 'parentLocation' can not be null");
        }
        entityPk.setParentLocation(parentLocation);
        LocationAssociation entity = this.load(childLocation, parentLocation);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LocationAssociation> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LocationAssociation.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LocationAssociation entity) {
        LocationAssociation target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LocationAssociation toEntity(Object[] row) {
        LocationAssociation target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LocationAssociation)) continue;
                target = (LocationAssociation)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationAssociationImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LocationAssociationImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LocationAssociation> search(Search search) {
        return this.search(0, search);
    }
}

