/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.conversion;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.conversion.RoundWeightConversion;
import fr.ifremer.adagio.core.dao.referential.conversion.RoundWeightConversionDao;
import fr.ifremer.adagio.core.dao.referential.conversion.RoundWeightConversionImpl;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.pmfm.QualitativeValue;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class RoundWeightConversionDaoBase
extends HibernateDaoSupport
implements RoundWeightConversionDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("RoundWeightConversion.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(RoundWeightConversionImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (RoundWeightConversion)entity);
    }

    @Override
    public RoundWeightConversion load(Integer id) {
        return (RoundWeightConversion)this.load(0, id);
    }

    @Override
    public Collection<RoundWeightConversion> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(RoundWeightConversionImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public RoundWeightConversion create(RoundWeightConversion roundWeightConversion) {
        return (RoundWeightConversion)this.create(0, roundWeightConversion);
    }

    @Override
    public Object create(int transform, RoundWeightConversion roundWeightConversion) {
        if (roundWeightConversion == null) {
            throw new IllegalArgumentException("RoundWeightConversion.create - 'roundWeightConversion' can not be null");
        }
        this.getHibernateTemplate().save((Object)roundWeightConversion);
        return this.transformEntity(transform, roundWeightConversion);
    }

    @Override
    public Collection<RoundWeightConversion> create(Collection<RoundWeightConversion> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<RoundWeightConversion> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("RoundWeightConversion.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    RoundWeightConversionDaoBase.this.create(transform, (RoundWeightConversion)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public RoundWeightConversion create(Float conversionCoefficient, Date startDate, Date endDate, String description, Timestamp updateDate, QualitativeValue preserving, QualitativeValue dressing, TaxonGroup taxonGroup, Location location) {
        return (RoundWeightConversion)this.create(0, conversionCoefficient, startDate, endDate, description, updateDate, preserving, dressing, taxonGroup, location);
    }

    @Override
    public Object create(int transform, Float conversionCoefficient, Date startDate, Date endDate, String description, Timestamp updateDate, QualitativeValue preserving, QualitativeValue dressing, TaxonGroup taxonGroup, Location location) {
        RoundWeightConversionImpl entity = new RoundWeightConversionImpl();
        entity.setConversionCoefficient(conversionCoefficient);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entity.setPreserving(preserving);
        entity.setDressing(dressing);
        entity.setTaxonGroup(taxonGroup);
        entity.setLocation(location);
        return this.create(transform, entity);
    }

    @Override
    public RoundWeightConversion create(Float conversionCoefficient, QualitativeValue dressing, Location location, QualitativeValue preserving, Date startDate, TaxonGroup taxonGroup) {
        return (RoundWeightConversion)this.create(0, conversionCoefficient, dressing, location, preserving, startDate, taxonGroup);
    }

    @Override
    public Object create(int transform, Float conversionCoefficient, QualitativeValue dressing, Location location, QualitativeValue preserving, Date startDate, TaxonGroup taxonGroup) {
        RoundWeightConversionImpl entity = new RoundWeightConversionImpl();
        entity.setConversionCoefficient(conversionCoefficient);
        entity.setDressing(dressing);
        entity.setLocation(location);
        entity.setPreserving(preserving);
        entity.setStartDate(startDate);
        entity.setTaxonGroup(taxonGroup);
        return this.create(transform, entity);
    }

    @Override
    public void update(RoundWeightConversion roundWeightConversion) {
        if (roundWeightConversion == null) {
            throw new IllegalArgumentException("RoundWeightConversion.update - 'roundWeightConversion' can not be null");
        }
        this.getHibernateTemplate().update((Object)roundWeightConversion);
    }

    @Override
    public void update(final Collection<RoundWeightConversion> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("RoundWeightConversion.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    RoundWeightConversionDaoBase.this.update((RoundWeightConversion)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(RoundWeightConversion roundWeightConversion) {
        if (roundWeightConversion == null) {
            throw new IllegalArgumentException("RoundWeightConversion.remove - 'roundWeightConversion' can not be null");
        }
        this.getHibernateTemplate().delete((Object)roundWeightConversion);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("RoundWeightConversion.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        RoundWeightConversion entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<RoundWeightConversion> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("RoundWeightConversion.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, RoundWeightConversion entity) {
        RoundWeightConversion target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected RoundWeightConversion toEntity(Object[] row) {
        RoundWeightConversion target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof RoundWeightConversion)) continue;
                target = (RoundWeightConversion)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), RoundWeightConversionImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), RoundWeightConversionImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<RoundWeightConversion> search(Search search) {
        return this.search(0, search);
    }
}

