/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential.buyer;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.Status;
import fr.ifremer.adagio.core.dao.referential.buyer.Buyer;
import fr.ifremer.adagio.core.dao.referential.buyer.BuyerDao;
import fr.ifremer.adagio.core.dao.referential.buyer.BuyerImpl;
import fr.ifremer.adagio.core.dao.referential.buyer.BuyerType;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class BuyerDaoBase
extends HibernateDaoSupport
implements BuyerDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Buyer.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(BuyerImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Buyer)entity);
    }

    @Override
    public Buyer load(Integer id) {
        return (Buyer)this.load(0, id);
    }

    @Override
    public Collection<Buyer> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(BuyerImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Buyer create(Buyer buyer) {
        return (Buyer)this.create(0, buyer);
    }

    @Override
    public Object create(int transform, Buyer buyer) {
        if (buyer == null) {
            throw new IllegalArgumentException("Buyer.create - 'buyer' can not be null");
        }
        this.getHibernateTemplate().save((Object)buyer);
        return this.transformEntity(transform, buyer);
    }

    @Override
    public Collection<Buyer> create(Collection<Buyer> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Buyer> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Buyer.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    BuyerDaoBase.this.create(transform, (Buyer)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Buyer create(String registrationCode, String name, String street, String zipCode, String city, String address, Timestamp updateDate, Status status, BuyerType buyerType) {
        return (Buyer)this.create(0, registrationCode, name, street, zipCode, city, address, updateDate, status, buyerType);
    }

    @Override
    public Object create(int transform, String registrationCode, String name, String street, String zipCode, String city, String address, Timestamp updateDate, Status status, BuyerType buyerType) {
        BuyerImpl entity = new BuyerImpl();
        entity.setRegistrationCode(registrationCode);
        entity.setName(name);
        entity.setStreet(street);
        entity.setZipCode(zipCode);
        entity.setCity(city);
        entity.setAddress(address);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        entity.setBuyerType(buyerType);
        return this.create(transform, entity);
    }

    @Override
    public Buyer create(BuyerType buyerType, Status status) {
        return (Buyer)this.create(0, buyerType, status);
    }

    @Override
    public Object create(int transform, BuyerType buyerType, Status status) {
        BuyerImpl entity = new BuyerImpl();
        entity.setBuyerType(buyerType);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Buyer buyer) {
        if (buyer == null) {
            throw new IllegalArgumentException("Buyer.update - 'buyer' can not be null");
        }
        this.getHibernateTemplate().update((Object)buyer);
    }

    @Override
    public void update(final Collection<Buyer> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Buyer.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    BuyerDaoBase.this.update((Buyer)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Buyer buyer) {
        if (buyer == null) {
            throw new IllegalArgumentException("Buyer.remove - 'buyer' can not be null");
        }
        this.getHibernateTemplate().delete((Object)buyer);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Buyer.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Buyer entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Buyer> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Buyer.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Buyer entity) {
        Buyer target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Buyer toEntity(Object[] row) {
        Buyer target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Buyer)) continue;
                target = (Buyer)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), BuyerImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), BuyerImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Buyer> search(Search search) {
        return this.search(0, search);
    }
}

