/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.data.history.ProcessingHistory;
import fr.ifremer.adagio.core.dao.referential.ProcessingType;
import fr.ifremer.adagio.core.dao.referential.ProcessingTypeDao;
import fr.ifremer.adagio.core.dao.referential.ProcessingTypeImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class ProcessingTypeDaoBase
extends HibernateDaoSupport
implements ProcessingTypeDao {
    @Override
    public Object load(int transform, String code) {
        if (code == null) {
            throw new IllegalArgumentException("ProcessingType.load - 'code' can not be null");
        }
        String entityPk = code;
        Object entity = this.getHibernateTemplate().get(ProcessingTypeImpl.class, (Serializable)((Object)entityPk));
        return this.transformEntity(transform, (ProcessingType)entity);
    }

    @Override
    public ProcessingType load(String code) {
        return (ProcessingType)this.load(0, code);
    }

    @Override
    public Collection<ProcessingType> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(ProcessingTypeImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public ProcessingType create(ProcessingType processingType) {
        return (ProcessingType)this.create(0, processingType);
    }

    @Override
    public Object create(int transform, ProcessingType processingType) {
        if (processingType == null) {
            throw new IllegalArgumentException("ProcessingType.create - 'processingType' can not be null");
        }
        this.getHibernateTemplate().save((Object)processingType);
        return this.transformEntity(transform, processingType);
    }

    @Override
    public Collection<ProcessingType> create(Collection<ProcessingType> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<ProcessingType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ProcessingType.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ProcessingTypeDaoBase.this.create(transform, (ProcessingType)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public ProcessingType create(String code, String description, Timestamp updateDate, Status status, Collection<ProcessingHistory> processingHistories) {
        return (ProcessingType)this.create(0, code, description, updateDate, status, processingHistories);
    }

    @Override
    public Object create(int transform, String code, String description, Timestamp updateDate, Status status, Collection<ProcessingHistory> processingHistories) {
        ProcessingTypeImpl entity = new ProcessingTypeImpl();
        entity.setCode(code);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        entity.setProcessingHistories(processingHistories);
        return this.create(transform, entity);
    }

    @Override
    public ProcessingType create(String code, Status status) {
        return (ProcessingType)this.create(0, code, status);
    }

    @Override
    public Object create(int transform, String code, Status status) {
        ProcessingTypeImpl entity = new ProcessingTypeImpl();
        entity.setCode(code);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(ProcessingType processingType) {
        if (processingType == null) {
            throw new IllegalArgumentException("ProcessingType.update - 'processingType' can not be null");
        }
        this.getHibernateTemplate().update((Object)processingType);
    }

    @Override
    public void update(final Collection<ProcessingType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ProcessingType.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ProcessingTypeDaoBase.this.update((ProcessingType)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(ProcessingType processingType) {
        if (processingType == null) {
            throw new IllegalArgumentException("ProcessingType.remove - 'processingType' can not be null");
        }
        this.getHibernateTemplate().delete((Object)processingType);
    }

    @Override
    public void remove(String code) {
        if (code == null) {
            throw new IllegalArgumentException("ProcessingType.remove - 'code' can not be null");
        }
        String entityPk = code;
        ProcessingType entity = this.load(code);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<ProcessingType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ProcessingType.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, ProcessingType entity) {
        ProcessingType target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected ProcessingType toEntity(Object[] row) {
        ProcessingType target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof ProcessingType)) continue;
                target = (ProcessingType)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ProcessingTypeImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ProcessingTypeImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<ProcessingType> search(Search search) {
        return this.search(0, search);
    }
}

