/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.referential;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.referential.ObjectType;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeDao;
import fr.ifremer.adagio.core.dao.referential.ObjectTypeImpl;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class ObjectTypeDaoBase
extends HibernateDaoSupport
implements ObjectTypeDao {
    @Override
    public Object load(int transform, String code) {
        if (code == null) {
            throw new IllegalArgumentException("ObjectType.load - 'code' can not be null");
        }
        String entityPk = code;
        Object entity = this.getHibernateTemplate().get(ObjectTypeImpl.class, (Serializable)((Object)entityPk));
        return this.transformEntity(transform, (ObjectType)entity);
    }

    @Override
    public ObjectType load(String code) {
        return (ObjectType)this.load(0, code);
    }

    @Override
    public Collection<ObjectType> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(ObjectTypeImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public ObjectType create(ObjectType objectType) {
        return (ObjectType)this.create(0, objectType);
    }

    @Override
    public Object create(int transform, ObjectType objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("ObjectType.create - 'objectType' can not be null");
        }
        this.getHibernateTemplate().save((Object)objectType);
        return this.transformEntity(transform, objectType);
    }

    @Override
    public Collection<ObjectType> create(Collection<ObjectType> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<ObjectType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ObjectType.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ObjectTypeDaoBase.this.create(transform, (ObjectType)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public ObjectType create(String code, String name, String description, Timestamp updateDate) {
        return (ObjectType)this.create(0, code, name, description, updateDate);
    }

    @Override
    public Object create(int transform, String code, String name, String description, Timestamp updateDate) {
        ObjectTypeImpl entity = new ObjectTypeImpl();
        entity.setCode(code);
        entity.setName(name);
        entity.setDescription(description);
        entity.setUpdateDate(updateDate);
        return this.create(transform, entity);
    }

    @Override
    public ObjectType create(String code, String name) {
        return (ObjectType)this.create(0, code, name);
    }

    @Override
    public Object create(int transform, String code, String name) {
        ObjectTypeImpl entity = new ObjectTypeImpl();
        entity.setCode(code);
        entity.setName(name);
        return this.create(transform, entity);
    }

    @Override
    public void update(ObjectType objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("ObjectType.update - 'objectType' can not be null");
        }
        this.getHibernateTemplate().update((Object)objectType);
    }

    @Override
    public void update(final Collection<ObjectType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ObjectType.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ObjectTypeDaoBase.this.update((ObjectType)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(ObjectType objectType) {
        if (objectType == null) {
            throw new IllegalArgumentException("ObjectType.remove - 'objectType' can not be null");
        }
        this.getHibernateTemplate().delete((Object)objectType);
    }

    @Override
    public void remove(String code) {
        if (code == null) {
            throw new IllegalArgumentException("ObjectType.remove - 'code' can not be null");
        }
        String entityPk = code;
        ObjectType entity = this.load(code);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<ObjectType> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("ObjectType.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, ObjectType entity) {
        ObjectType target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected ObjectType toEntity(Object[] row) {
        ObjectType target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof ObjectType)) continue;
                target = (ObjectType)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ObjectTypeImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ObjectTypeImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<ObjectType> search(Search search) {
        return this.search(0, search);
    }
}

