/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.transshipment;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.transshipment.Transshipment;
import fr.ifremer.adagio.core.dao.data.transshipment.TransshipmentDao;
import fr.ifremer.adagio.core.dao.data.transshipment.TransshipmentImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class TransshipmentDaoBase
extends HibernateDaoSupport
implements TransshipmentDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Transshipment.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(TransshipmentImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Transshipment)entity);
    }

    @Override
    public Transshipment load(Integer id) {
        return (Transshipment)this.load(0, id);
    }

    @Override
    public Collection<Transshipment> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(TransshipmentImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Transshipment create(Transshipment transshipment) {
        return (Transshipment)this.create(0, transshipment);
    }

    @Override
    public Object create(int transform, Transshipment transshipment) {
        if (transshipment == null) {
            throw new IllegalArgumentException("Transshipment.create - 'transshipment' can not be null");
        }
        this.getHibernateTemplate().save((Object)transshipment);
        return this.transformEntity(transform, transshipment);
    }

    @Override
    public Collection<Transshipment> create(Collection<Transshipment> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Transshipment> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Transshipment.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TransshipmentDaoBase.this.create(transform, (Transshipment)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Transshipment create(Date transshipmentDateTime, Short rankOrder, String comments, Date creationDate, Date controlDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Location transshipmentLocation, Vessel toVessel, FishingTrip fishingTrip, Program program, Person recorderPerson, QualityFlag qualityFlag, Department recorderDepartment, Vessel fromVessel, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
        return (Transshipment)this.create(0, transshipmentDateTime, rankOrder, comments, creationDate, controlDate, qualificationDate, qualificationComments, updateDate, transshipmentLocation, toVessel, fishingTrip, program, recorderPerson, qualityFlag, recorderDepartment, fromVessel, surveyMeasurements, produces);
    }

    @Override
    public Object create(int transform, Date transshipmentDateTime, Short rankOrder, String comments, Date creationDate, Date controlDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Location transshipmentLocation, Vessel toVessel, FishingTrip fishingTrip, Program program, Person recorderPerson, QualityFlag qualityFlag, Department recorderDepartment, Vessel fromVessel, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
        TransshipmentImpl entity = new TransshipmentImpl();
        entity.setTransshipmentDateTime(transshipmentDateTime);
        entity.setRankOrder(rankOrder);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setControlDate(controlDate);
        entity.setQualificationDate(qualificationDate);
        entity.setQualificationComments(qualificationComments);
        entity.setUpdateDate(updateDate);
        entity.setTransshipmentLocation(transshipmentLocation);
        entity.setToVessel(toVessel);
        entity.setFishingTrip(fishingTrip);
        entity.setProgram(program);
        entity.setRecorderPerson(recorderPerson);
        entity.setQualityFlag(qualityFlag);
        entity.setRecorderDepartment(recorderDepartment);
        entity.setFromVessel(fromVessel);
        entity.setSurveyMeasurements(surveyMeasurements);
        entity.setProduces(produces);
        return this.create(transform, entity);
    }

    @Override
    public Transshipment create(Date creationDate, Vessel fromVessel, Program program, QualityFlag qualityFlag, Department recorderDepartment, Vessel toVessel, Date transshipmentDateTime) {
        return (Transshipment)this.create(0, creationDate, fromVessel, program, qualityFlag, recorderDepartment, toVessel, transshipmentDateTime);
    }

    @Override
    public Object create(int transform, Date creationDate, Vessel fromVessel, Program program, QualityFlag qualityFlag, Department recorderDepartment, Vessel toVessel, Date transshipmentDateTime) {
        TransshipmentImpl entity = new TransshipmentImpl();
        entity.setCreationDate(creationDate);
        entity.setFromVessel(fromVessel);
        entity.setProgram(program);
        entity.setQualityFlag(qualityFlag);
        entity.setRecorderDepartment(recorderDepartment);
        entity.setToVessel(toVessel);
        entity.setTransshipmentDateTime(transshipmentDateTime);
        return this.create(transform, entity);
    }

    @Override
    public void update(Transshipment transshipment) {
        if (transshipment == null) {
            throw new IllegalArgumentException("Transshipment.update - 'transshipment' can not be null");
        }
        this.getHibernateTemplate().update((Object)transshipment);
    }

    @Override
    public void update(final Collection<Transshipment> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Transshipment.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    TransshipmentDaoBase.this.update((Transshipment)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Transshipment transshipment) {
        if (transshipment == null) {
            throw new IllegalArgumentException("Transshipment.remove - 'transshipment' can not be null");
        }
        this.getHibernateTemplate().delete((Object)transshipment);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Transshipment.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Transshipment entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Transshipment> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Transshipment.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Transshipment entity) {
        Transshipment target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Transshipment toEntity(Object[] row) {
        Transshipment target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Transshipment)) continue;
                target = (Transshipment)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TransshipmentImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), TransshipmentImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Transshipment> search(Search search) {
        return this.search(0, search);
    }
}

