/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.survey.sale;

import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SaleMeasurement;
import fr.ifremer.adagio.core.dao.data.measure.SurveyMeasurement;
import fr.ifremer.adagio.core.dao.data.produce.Produce;
import fr.ifremer.adagio.core.dao.data.survey.declaration.DeclaredDocumentReference;
import fr.ifremer.adagio.core.dao.data.survey.fishingTrip.FishingTrip;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleImpl;
import fr.ifremer.adagio.core.dao.data.survey.sale.SaleOrigin;
import fr.ifremer.adagio.core.dao.data.survey.takeOver.TakeOver;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.SaleType;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.seller.Seller;
import fr.ifremer.adagio.core.dao.referential.vessel.Vessel;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public abstract class Sale
implements Serializable {
    private static final long serialVersionUID = 8081463357582260532L;
    private Integer id;
    private Date saleStartDate;
    private Date saleEndDate;
    private String synchronizationStatus;
    private String comments;
    private Date creationDate;
    private Date controlDate;
    private Date validationDate;
    private Date qualificationDate;
    private String qualificationComments;
    private Timestamp updateDate;
    private CatchBatch catchBatch;
    private TakeOver takeOver;
    private DeclaredDocumentReference declaredDocumentReference;
    private Collection<SaleOrigin> saleOrigins = new HashSet<SaleOrigin>();
    private Program program;
    private Person recorderPerson;
    private Seller seller;
    private Department recorderDepartment;
    private QualityFlag qualityFlag;
    private Vessel vessel;
    private FishingTrip fishingTrip;
    private Location saleLocation;
    private SaleType saleType;
    private Landing landing;
    private Collection<FishingArea> fishingAreas = new HashSet<FishingArea>();
    private Collection<SaleMeasurement> saleMeasurements = new HashSet<SaleMeasurement>();
    private Collection<SurveyMeasurement> surveyMeasurements = new HashSet<SurveyMeasurement>();
    private Collection<Produce> produces = new HashSet<Produce>();

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Date getSaleStartDate() {
        return this.saleStartDate;
    }

    public void setSaleStartDate(Date saleStartDate) {
        this.saleStartDate = saleStartDate;
    }

    public Date getSaleEndDate() {
        return this.saleEndDate;
    }

    public void setSaleEndDate(Date saleEndDate) {
        this.saleEndDate = saleEndDate;
    }

    public String getSynchronizationStatus() {
        return this.synchronizationStatus;
    }

    public void setSynchronizationStatus(String synchronizationStatus) {
        this.synchronizationStatus = synchronizationStatus;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    public Date getControlDate() {
        return this.controlDate;
    }

    public void setControlDate(Date controlDate) {
        this.controlDate = controlDate;
    }

    public Date getValidationDate() {
        return this.validationDate;
    }

    public void setValidationDate(Date validationDate) {
        this.validationDate = validationDate;
    }

    public Date getQualificationDate() {
        return this.qualificationDate;
    }

    public void setQualificationDate(Date qualificationDate) {
        this.qualificationDate = qualificationDate;
    }

    public String getQualificationComments() {
        return this.qualificationComments;
    }

    public void setQualificationComments(String qualificationComments) {
        this.qualificationComments = qualificationComments;
    }

    public Timestamp getUpdateDate() {
        return this.updateDate;
    }

    public void setUpdateDate(Timestamp updateDate) {
        this.updateDate = updateDate;
    }

    public CatchBatch getCatchBatch() {
        return this.catchBatch;
    }

    public void setCatchBatch(CatchBatch catchBatch) {
        this.catchBatch = catchBatch;
    }

    public TakeOver getTakeOver() {
        return this.takeOver;
    }

    public void setTakeOver(TakeOver takeOver) {
        this.takeOver = takeOver;
    }

    public DeclaredDocumentReference getDeclaredDocumentReference() {
        return this.declaredDocumentReference;
    }

    public void setDeclaredDocumentReference(DeclaredDocumentReference declaredDocumentReference) {
        this.declaredDocumentReference = declaredDocumentReference;
    }

    public Collection<SaleOrigin> getSaleOrigins() {
        return this.saleOrigins;
    }

    public void setSaleOrigins(Collection<SaleOrigin> saleOrigins) {
        this.saleOrigins = saleOrigins;
    }

    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        this.program = program;
    }

    public Person getRecorderPerson() {
        return this.recorderPerson;
    }

    public void setRecorderPerson(Person recorderPerson) {
        this.recorderPerson = recorderPerson;
    }

    public Seller getSeller() {
        return this.seller;
    }

    public void setSeller(Seller seller) {
        this.seller = seller;
    }

    public Department getRecorderDepartment() {
        return this.recorderDepartment;
    }

    public void setRecorderDepartment(Department recorderDepartment) {
        this.recorderDepartment = recorderDepartment;
    }

    public QualityFlag getQualityFlag() {
        return this.qualityFlag;
    }

    public void setQualityFlag(QualityFlag qualityFlag) {
        this.qualityFlag = qualityFlag;
    }

    public Vessel getVessel() {
        return this.vessel;
    }

    public void setVessel(Vessel vessel) {
        this.vessel = vessel;
    }

    public FishingTrip getFishingTrip() {
        return this.fishingTrip;
    }

    public void setFishingTrip(FishingTrip fishingTrip) {
        this.fishingTrip = fishingTrip;
    }

    public Location getSaleLocation() {
        return this.saleLocation;
    }

    public void setSaleLocation(Location saleLocation) {
        this.saleLocation = saleLocation;
    }

    public SaleType getSaleType() {
        return this.saleType;
    }

    public void setSaleType(SaleType saleType) {
        this.saleType = saleType;
    }

    public Landing getLanding() {
        return this.landing;
    }

    public void setLanding(Landing landing) {
        this.landing = landing;
    }

    public Collection<FishingArea> getFishingAreas() {
        return this.fishingAreas;
    }

    public void setFishingAreas(Collection<FishingArea> fishingAreas) {
        this.fishingAreas = fishingAreas;
    }

    public Collection<SaleMeasurement> getSaleMeasurements() {
        return this.saleMeasurements;
    }

    public void setSaleMeasurements(Collection<SaleMeasurement> saleMeasurements) {
        this.saleMeasurements = saleMeasurements;
    }

    public Collection<SurveyMeasurement> getSurveyMeasurements() {
        return this.surveyMeasurements;
    }

    public void setSurveyMeasurements(Collection<SurveyMeasurement> surveyMeasurements) {
        this.surveyMeasurements = surveyMeasurements;
    }

    public Collection<Produce> getProduces() {
        return this.produces;
    }

    public void setProduces(Collection<Produce> produces) {
        this.produces = produces;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Sale)) {
            return false;
        }
        Sale that = (Sale)object;
        return this.id != null && that.getId() != null && this.id.equals(that.getId());
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 29 * hashCode + (this.id == null ? 0 : this.id.hashCode());
        return hashCode;
    }

    public static final class Factory {
        public static Sale newInstance() {
            SaleImpl entity = new SaleImpl();
            return entity;
        }

        public static Sale newInstance(Date saleStartDate, String synchronizationStatus, Date creationDate, Program program, Department recorderDepartment, QualityFlag qualityFlag, Vessel vessel, Location saleLocation, SaleType saleType) {
            Sale entity = Factory.newInstance();
            entity.setSaleStartDate(saleStartDate);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setCreationDate(creationDate);
            entity.setProgram(program);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setSaleLocation(saleLocation);
            entity.setSaleType(saleType);
            return entity;
        }

        public static Sale newInstance(Date saleStartDate, Date saleEndDate, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, CatchBatch catchBatch, TakeOver takeOver, DeclaredDocumentReference declaredDocumentReference, Collection<SaleOrigin> saleOrigins, Program program, Person recorderPerson, Seller seller, Department recorderDepartment, QualityFlag qualityFlag, Vessel vessel, FishingTrip fishingTrip, Location saleLocation, SaleType saleType, Landing landing, Collection<FishingArea> fishingAreas, Collection<SaleMeasurement> saleMeasurements, Collection<SurveyMeasurement> surveyMeasurements, Collection<Produce> produces) {
            Sale entity = Factory.newInstance();
            entity.setSaleStartDate(saleStartDate);
            entity.setSaleEndDate(saleEndDate);
            entity.setSynchronizationStatus(synchronizationStatus);
            entity.setComments(comments);
            entity.setCreationDate(creationDate);
            entity.setControlDate(controlDate);
            entity.setValidationDate(validationDate);
            entity.setQualificationDate(qualificationDate);
            entity.setQualificationComments(qualificationComments);
            entity.setUpdateDate(updateDate);
            entity.setCatchBatch(catchBatch);
            entity.setTakeOver(takeOver);
            entity.setDeclaredDocumentReference(declaredDocumentReference);
            entity.setSaleOrigins(saleOrigins);
            entity.setProgram(program);
            entity.setRecorderPerson(recorderPerson);
            entity.setSeller(seller);
            entity.setRecorderDepartment(recorderDepartment);
            entity.setQualityFlag(qualityFlag);
            entity.setVessel(vessel);
            entity.setFishingTrip(fishingTrip);
            entity.setSaleLocation(saleLocation);
            entity.setSaleType(saleType);
            entity.setLanding(landing);
            entity.setFishingAreas(fishingAreas);
            entity.setSaleMeasurements(saleMeasurements);
            entity.setSurveyMeasurements(surveyMeasurements);
            entity.setProduces(produces);
            return entity;
        }
    }
}

