/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.survey.landing;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.data.survey.landing.Landing;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingOrigin;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingOriginDao;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingOriginImpl;
import fr.ifremer.adagio.core.dao.data.survey.landing.LandingOriginPK;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class LandingOriginDaoBase
extends HibernateDaoSupport
implements LandingOriginDao {
    @Override
    public Object load(int transform, Program program, Landing landing) {
        LandingOriginPK entityPk = new LandingOriginPK();
        if (program == null) {
            throw new IllegalArgumentException("LandingOrigin.load - 'program' can not be null");
        }
        if (landing == null) {
            throw new IllegalArgumentException("LandingOrigin.load - 'landing' can not be null");
        }
        entityPk.setProgram(program);
        entityPk.setLanding(landing);
        Object entity = this.getHibernateTemplate().get(LandingOriginImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LandingOrigin)entity);
    }

    @Override
    public LandingOrigin load(Program program, Landing landing) {
        return (LandingOrigin)this.load(0, program, landing);
    }

    @Override
    public Collection<LandingOrigin> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LandingOriginImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LandingOrigin create(LandingOrigin landingOrigin) {
        return (LandingOrigin)this.create(0, landingOrigin);
    }

    @Override
    public Object create(int transform, LandingOrigin landingOrigin) {
        if (landingOrigin == null) {
            throw new IllegalArgumentException("LandingOrigin.create - 'landingOrigin' can not be null");
        }
        this.getHibernateTemplate().save((Object)landingOrigin);
        return this.transformEntity(transform, landingOrigin);
    }

    @Override
    public Collection<LandingOrigin> create(Collection<LandingOrigin> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LandingOrigin> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LandingOrigin.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LandingOriginDaoBase.this.create(transform, (LandingOrigin)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LandingOrigin create(Program program, Landing landing) {
        return (LandingOrigin)this.create(0, program, landing);
    }

    @Override
    public Object create(int transform, Program program, Landing landing) {
        LandingOriginImpl entity = new LandingOriginImpl();
        LandingOriginPK entityPk = new LandingOriginPK();
        entity.setLandingOriginPk(entityPk);
        entityPk.setProgram(program);
        entityPk.setLanding(landing);
        return this.create(transform, entity);
    }

    @Override
    public void update(LandingOrigin landingOrigin) {
        if (landingOrigin == null) {
            throw new IllegalArgumentException("LandingOrigin.update - 'landingOrigin' can not be null");
        }
        this.getHibernateTemplate().update((Object)landingOrigin);
    }

    @Override
    public void update(final Collection<LandingOrigin> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LandingOrigin.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LandingOriginDaoBase.this.update((LandingOrigin)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LandingOrigin landingOrigin) {
        if (landingOrigin == null) {
            throw new IllegalArgumentException("LandingOrigin.remove - 'landingOrigin' can not be null");
        }
        this.getHibernateTemplate().delete((Object)landingOrigin);
    }

    @Override
    public void remove(Program program, Landing landing) {
        LandingOriginPK entityPk = new LandingOriginPK();
        if (program == null) {
            throw new IllegalArgumentException("LandingOrigin.remove - 'program' can not be null");
        }
        entityPk.setProgram(program);
        if (landing == null) {
            throw new IllegalArgumentException("LandingOrigin.remove - 'landing' can not be null");
        }
        entityPk.setLanding(landing);
        LandingOrigin entity = this.load(program, landing);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LandingOrigin> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LandingOrigin.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LandingOrigin entity) {
        LandingOrigin target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LandingOrigin toEntity(Object[] row) {
        LandingOrigin target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LandingOrigin)) continue;
                target = (LandingOrigin)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LandingOriginImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LandingOriginImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LandingOrigin> search(Search search) {
        return this.search(0, search);
    }
}

