/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.sample;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.Person;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.fishingArea.FishingArea;
import fr.ifremer.adagio.core.dao.data.measure.SampleMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.sample.Sample;
import fr.ifremer.adagio.core.dao.data.sample.SampleDao;
import fr.ifremer.adagio.core.dao.data.sample.SampleImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.pmfm.Matrix;
import fr.ifremer.adagio.core.dao.referential.pmfm.Unit;
import fr.ifremer.adagio.core.dao.referential.taxon.ReferenceTaxon;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroup;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class SampleDaoBase
extends HibernateDaoSupport
implements SampleDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Sample.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(SampleImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Sample)entity);
    }

    @Override
    public Sample load(Integer id) {
        return (Sample)this.load(0, id);
    }

    @Override
    public Collection<Sample> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(SampleImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Sample create(Sample sample) {
        return (Sample)this.create(0, sample);
    }

    @Override
    public Object create(int transform, Sample sample) {
        if (sample == null) {
            throw new IllegalArgumentException("Sample.create - 'sample' can not be null");
        }
        this.getHibernateTemplate().save((Object)sample);
        return this.transformEntity(transform, sample);
    }

    @Override
    public Collection<Sample> create(Collection<Sample> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Sample> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Sample.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SampleDaoBase.this.create(transform, (Sample)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Sample create(String label, Date sampleDate, Short individualCount, Float size, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Collection<FishingArea> fishingAreas, FishingOperation fishingOperation, Matrix matrix, Department recorderDepartment, Program program, Sample parentSample, Collection<Sample> childSamples, ReferenceTaxon referenceTaxon, TaxonGroup taxonGroup, QualityFlag qualityFlag, Person recorderPerson, Unit sizeUnit, Batch batch, Collection<SampleMeasurement> sampleMeasurements) {
        return (Sample)this.create(0, label, sampleDate, individualCount, size, synchronizationStatus, comments, creationDate, controlDate, validationDate, qualificationDate, qualificationComments, updateDate, fishingAreas, fishingOperation, matrix, recorderDepartment, program, parentSample, childSamples, referenceTaxon, taxonGroup, qualityFlag, recorderPerson, sizeUnit, batch, sampleMeasurements);
    }

    @Override
    public Object create(int transform, String label, Date sampleDate, Short individualCount, Float size, String synchronizationStatus, String comments, Date creationDate, Date controlDate, Date validationDate, Date qualificationDate, String qualificationComments, Timestamp updateDate, Collection<FishingArea> fishingAreas, FishingOperation fishingOperation, Matrix matrix, Department recorderDepartment, Program program, Sample parentSample, Collection<Sample> childSamples, ReferenceTaxon referenceTaxon, TaxonGroup taxonGroup, QualityFlag qualityFlag, Person recorderPerson, Unit sizeUnit, Batch batch, Collection<SampleMeasurement> sampleMeasurements) {
        SampleImpl entity = new SampleImpl();
        entity.setLabel(label);
        entity.setSampleDate(sampleDate);
        entity.setIndividualCount(individualCount);
        entity.setSize(size);
        entity.setSynchronizationStatus(synchronizationStatus);
        entity.setComments(comments);
        entity.setCreationDate(creationDate);
        entity.setControlDate(controlDate);
        entity.setValidationDate(validationDate);
        entity.setQualificationDate(qualificationDate);
        entity.setQualificationComments(qualificationComments);
        entity.setUpdateDate(updateDate);
        entity.setFishingAreas(fishingAreas);
        entity.setFishingOperation(fishingOperation);
        entity.setMatrix(matrix);
        entity.setRecorderDepartment(recorderDepartment);
        entity.setProgram(program);
        entity.setParentSample(parentSample);
        entity.setChildSamples(childSamples);
        entity.setReferenceTaxon(referenceTaxon);
        entity.setTaxonGroup(taxonGroup);
        entity.setQualityFlag(qualityFlag);
        entity.setRecorderPerson(recorderPerson);
        entity.setSizeUnit(sizeUnit);
        entity.setBatch(batch);
        entity.setSampleMeasurements(sampleMeasurements);
        return this.create(transform, entity);
    }

    @Override
    public Sample create(Date creationDate, String label, Matrix matrix, Program program, QualityFlag qualityFlag, Department recorderDepartment, String synchronizationStatus) {
        return (Sample)this.create(0, creationDate, label, matrix, program, qualityFlag, recorderDepartment, synchronizationStatus);
    }

    @Override
    public Object create(int transform, Date creationDate, String label, Matrix matrix, Program program, QualityFlag qualityFlag, Department recorderDepartment, String synchronizationStatus) {
        SampleImpl entity = new SampleImpl();
        entity.setCreationDate(creationDate);
        entity.setLabel(label);
        entity.setMatrix(matrix);
        entity.setProgram(program);
        entity.setQualityFlag(qualityFlag);
        entity.setRecorderDepartment(recorderDepartment);
        entity.setSynchronizationStatus(synchronizationStatus);
        return this.create(transform, entity);
    }

    @Override
    public void update(Sample sample) {
        if (sample == null) {
            throw new IllegalArgumentException("Sample.update - 'sample' can not be null");
        }
        this.getHibernateTemplate().update((Object)sample);
    }

    @Override
    public void update(final Collection<Sample> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Sample.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    SampleDaoBase.this.update((Sample)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Sample sample) {
        if (sample == null) {
            throw new IllegalArgumentException("Sample.remove - 'sample' can not be null");
        }
        this.getHibernateTemplate().delete((Object)sample);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Sample.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Sample entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Sample> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Sample.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Sample entity) {
        Sample target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Sample toEntity(Object[] row) {
        Sample target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Sample)) continue;
                target = (Sample)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SampleImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), SampleImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Sample> search(Search search) {
        return this.search(0, search);
    }
}

