/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.data.link;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.data.link.LinkedItem;
import fr.ifremer.adagio.core.dao.data.link.LinkedItemDao;
import fr.ifremer.adagio.core.dao.data.link.LinkedItemImpl;
import fr.ifremer.adagio.core.dao.referential.LinkedItemType;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class LinkedItemDaoBase
extends HibernateDaoSupport
implements LinkedItemDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LinkedItem.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(LinkedItemImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (LinkedItem)entity);
    }

    @Override
    public LinkedItem load(Integer id) {
        return (LinkedItem)this.load(0, id);
    }

    @Override
    public Collection<LinkedItem> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(LinkedItemImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public LinkedItem create(LinkedItem linkedItem) {
        return (LinkedItem)this.create(0, linkedItem);
    }

    @Override
    public Object create(int transform, LinkedItem linkedItem) {
        if (linkedItem == null) {
            throw new IllegalArgumentException("LinkedItem.create - 'linkedItem' can not be null");
        }
        this.getHibernateTemplate().save((Object)linkedItem);
        return this.transformEntity(transform, linkedItem);
    }

    @Override
    public Collection<LinkedItem> create(Collection<LinkedItem> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<LinkedItem> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LinkedItem.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LinkedItemDaoBase.this.create(transform, (LinkedItem)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public LinkedItem create(Integer fromObjectId, String fromObjectCode, Integer toObjectId, String toObjectCode, Date startDate, Date endDate, Timestamp updateDate, LinkedItemType linkedItemType) {
        return (LinkedItem)this.create(0, fromObjectId, fromObjectCode, toObjectId, toObjectCode, startDate, endDate, updateDate, linkedItemType);
    }

    @Override
    public Object create(int transform, Integer fromObjectId, String fromObjectCode, Integer toObjectId, String toObjectCode, Date startDate, Date endDate, Timestamp updateDate, LinkedItemType linkedItemType) {
        LinkedItemImpl entity = new LinkedItemImpl();
        entity.setFromObjectId(fromObjectId);
        entity.setFromObjectCode(fromObjectCode);
        entity.setToObjectId(toObjectId);
        entity.setToObjectCode(toObjectCode);
        entity.setStartDate(startDate);
        entity.setEndDate(endDate);
        entity.setUpdateDate(updateDate);
        entity.setLinkedItemType(linkedItemType);
        return this.create(transform, entity);
    }

    @Override
    public LinkedItem create(LinkedItemType linkedItemType) {
        return (LinkedItem)this.create(0, linkedItemType);
    }

    @Override
    public Object create(int transform, LinkedItemType linkedItemType) {
        LinkedItemImpl entity = new LinkedItemImpl();
        entity.setLinkedItemType(linkedItemType);
        return this.create(transform, entity);
    }

    @Override
    public void update(LinkedItem linkedItem) {
        if (linkedItem == null) {
            throw new IllegalArgumentException("LinkedItem.update - 'linkedItem' can not be null");
        }
        this.getHibernateTemplate().update((Object)linkedItem);
    }

    @Override
    public void update(final Collection<LinkedItem> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LinkedItem.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    LinkedItemDaoBase.this.update((LinkedItem)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(LinkedItem linkedItem) {
        if (linkedItem == null) {
            throw new IllegalArgumentException("LinkedItem.remove - 'linkedItem' can not be null");
        }
        this.getHibernateTemplate().delete((Object)linkedItem);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("LinkedItem.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        LinkedItem entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<LinkedItem> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("LinkedItem.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, LinkedItem entity) {
        LinkedItem target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected LinkedItem toEntity(Object[] row) {
        LinkedItem target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof LinkedItem)) continue;
                target = (LinkedItem)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LinkedItemImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), LinkedItemImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<LinkedItem> search(Search search) {
        return this.search(0, search);
    }
}

