/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.administration.user;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program2Department;
import fr.ifremer.adagio.core.dao.administration.user.Department;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentDao;
import fr.ifremer.adagio.core.dao.administration.user.DepartmentImpl;
import fr.ifremer.adagio.core.dao.referential.Status;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class DepartmentDaoBase
extends HibernateDaoSupport
implements DepartmentDao {
    @Override
    public Object load(int transform, Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Department.load - 'id' can not be null");
        }
        Integer entityPk = id;
        Object entity = this.getHibernateTemplate().get(DepartmentImpl.class, (Serializable)entityPk);
        return this.transformEntity(transform, (Department)entity);
    }

    @Override
    public Department load(Integer id) {
        return (Department)this.load(0, id);
    }

    @Override
    public Collection<Department> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(DepartmentImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Department create(Department department) {
        return (Department)this.create(0, department);
    }

    @Override
    public Object create(int transform, Department department) {
        if (department == null) {
            throw new IllegalArgumentException("Department.create - 'department' can not be null");
        }
        this.getHibernateTemplate().save((Object)department);
        return this.transformEntity(transform, department);
    }

    @Override
    public Collection<Department> create(Collection<Department> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Department> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Department.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    DepartmentDaoBase.this.create(transform, (Department)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Department create(String code, String name, String email, String address, String phone, Boolean isLdap, Date creationDate, Timestamp updateDate, Status status, Collection<Department> departments, Department parentDepartment, Collection<Program2Department> program2Departments) {
        return (Department)this.create(0, code, name, email, address, phone, isLdap, creationDate, updateDate, status, departments, parentDepartment, program2Departments);
    }

    @Override
    public Object create(int transform, String code, String name, String email, String address, String phone, Boolean isLdap, Date creationDate, Timestamp updateDate, Status status, Collection<Department> departments, Department parentDepartment, Collection<Program2Department> program2Departments) {
        DepartmentImpl entity = new DepartmentImpl();
        entity.setCode(code);
        entity.setName(name);
        entity.setEmail(email);
        entity.setAddress(address);
        entity.setPhone(phone);
        entity.setIsLdap(isLdap);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setStatus(status);
        entity.setDepartments(departments);
        entity.setParentDepartment(parentDepartment);
        entity.setProgram2Departments(program2Departments);
        return this.create(transform, entity);
    }

    @Override
    public Department create(String code, Date creationDate, Boolean isLdap, String name, Status status) {
        return (Department)this.create(0, code, creationDate, isLdap, name, status);
    }

    @Override
    public Object create(int transform, String code, Date creationDate, Boolean isLdap, String name, Status status) {
        DepartmentImpl entity = new DepartmentImpl();
        entity.setCode(code);
        entity.setCreationDate(creationDate);
        entity.setIsLdap(isLdap);
        entity.setName(name);
        entity.setStatus(status);
        return this.create(transform, entity);
    }

    @Override
    public void update(Department department) {
        if (department == null) {
            throw new IllegalArgumentException("Department.update - 'department' can not be null");
        }
        this.getHibernateTemplate().update((Object)department);
    }

    @Override
    public void update(final Collection<Department> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Department.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    DepartmentDaoBase.this.update((Department)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Department department) {
        if (department == null) {
            throw new IllegalArgumentException("Department.remove - 'department' can not be null");
        }
        this.getHibernateTemplate().delete((Object)department);
    }

    @Override
    public void remove(Integer id) {
        if (id == null) {
            throw new IllegalArgumentException("Department.remove - 'id' can not be null");
        }
        Integer entityPk = id;
        Department entity = this.load(id);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Department> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Department.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Department entity) {
        Department target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Department toEntity(Object[] row) {
        Department target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Department)) continue;
                target = (Department)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), DepartmentImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), DepartmentImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Department> search(Search search) {
        return this.search(0, search);
    }
}

