/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.core.dao.administration.programStrategy;

import fr.ifremer.adagio.core.dao.PaginationResult;
import fr.ifremer.adagio.core.dao.PrincipalStore;
import fr.ifremer.adagio.core.dao.PropertySearch;
import fr.ifremer.adagio.core.dao.Search;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program2Department;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Program2Person;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramDao;
import fr.ifremer.adagio.core.dao.administration.programStrategy.ProgramImpl;
import fr.ifremer.adagio.core.dao.administration.programStrategy.Strategy;
import fr.ifremer.adagio.core.dao.referential.gear.GearClassification;
import fr.ifremer.adagio.core.dao.referential.location.Location;
import fr.ifremer.adagio.core.dao.referential.location.LocationClassification;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonGroupType;
import java.io.Serializable;
import java.security.Principal;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.support.HibernateDaoSupport;

public abstract class ProgramDaoBase
extends HibernateDaoSupport
implements ProgramDao {
    @Override
    public Object load(int transform, String code) {
        if (code == null) {
            throw new IllegalArgumentException("Program.load - 'code' can not be null");
        }
        String entityPk = code;
        Object entity = this.getHibernateTemplate().get(ProgramImpl.class, (Serializable)((Object)entityPk));
        return this.transformEntity(transform, (Program)entity);
    }

    @Override
    public Program load(String code) {
        return (Program)this.load(0, code);
    }

    @Override
    public Collection<Program> loadAll() {
        return this.loadAll(0);
    }

    @Override
    public Collection<?> loadAll(int transform) {
        return this.loadAll(transform, -1, -1);
    }

    @Override
    public Collection<?> loadAll(int pageNumber, int pageSize) {
        return this.loadAll(0, pageNumber, pageSize);
    }

    @Override
    public Collection<?> loadAll(int transform, int pageNumber, int pageSize) {
        try {
            Criteria criteria = this.getSession(false).createCriteria(ProgramImpl.class);
            if (pageNumber > 0 && pageSize > 0) {
                criteria.setFirstResult(this.calculateFirstResult(pageNumber, pageSize));
                criteria.setMaxResults(pageSize);
            }
            List results = criteria.list();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    private int calculateFirstResult(int pageNumber, int pageSize) {
        int firstResult = 0;
        if (pageNumber > 0) {
            firstResult = (pageNumber - 1) * pageSize;
        }
        return firstResult;
    }

    @Override
    public Program create(Program program) {
        return (Program)this.create(0, program);
    }

    @Override
    public Object create(int transform, Program program) {
        if (program == null) {
            throw new IllegalArgumentException("Program.create - 'program' can not be null");
        }
        this.getHibernateTemplate().save((Object)program);
        return this.transformEntity(transform, program);
    }

    @Override
    public Collection<Program> create(Collection<Program> entities) {
        return this.create(0, entities);
    }

    @Override
    public Collection<?> create(final int transform, final Collection<Program> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Program.create - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ProgramDaoBase.this.create(transform, (Program)entityIterator.next());
                }
                return null;
            }
        });
        return entities;
    }

    @Override
    public Program create(String code, String name, String description, Date creationDate, Timestamp updateDate, Collection<Strategy> strategies, Collection<Location> locations, Collection<LocationClassification> locationClassifications, Collection<Program2Person> programUsers, TaxonGroupType taxonGroupType, GearClassification gearClassification, Collection<Program2Department> program2Departments) {
        return (Program)this.create(0, code, name, description, creationDate, updateDate, strategies, locations, locationClassifications, programUsers, taxonGroupType, gearClassification, program2Departments);
    }

    @Override
    public Object create(int transform, String code, String name, String description, Date creationDate, Timestamp updateDate, Collection<Strategy> strategies, Collection<Location> locations, Collection<LocationClassification> locationClassifications, Collection<Program2Person> programUsers, TaxonGroupType taxonGroupType, GearClassification gearClassification, Collection<Program2Department> program2Departments) {
        ProgramImpl entity = new ProgramImpl();
        entity.setCode(code);
        entity.setName(name);
        entity.setDescription(description);
        entity.setCreationDate(creationDate);
        entity.setUpdateDate(updateDate);
        entity.setStrategies(strategies);
        entity.setLocations(locations);
        entity.setLocationClassifications(locationClassifications);
        entity.setProgramUsers(programUsers);
        entity.setTaxonGroupType(taxonGroupType);
        entity.setGearClassification(gearClassification);
        entity.setProgram2Departments(program2Departments);
        return this.create(transform, entity);
    }

    @Override
    public Program create(String code, Date creationDate, String description, GearClassification gearClassification, Collection<LocationClassification> locationClassifications, String name, TaxonGroupType taxonGroupType) {
        return (Program)this.create(0, code, creationDate, description, gearClassification, locationClassifications, name, taxonGroupType);
    }

    @Override
    public Object create(int transform, String code, Date creationDate, String description, GearClassification gearClassification, Collection<LocationClassification> locationClassifications, String name, TaxonGroupType taxonGroupType) {
        ProgramImpl entity = new ProgramImpl();
        entity.setCode(code);
        entity.setCreationDate(creationDate);
        entity.setDescription(description);
        entity.setGearClassification(gearClassification);
        entity.setLocationClassifications(locationClassifications);
        entity.setName(name);
        entity.setTaxonGroupType(taxonGroupType);
        return this.create(transform, entity);
    }

    @Override
    public void update(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("Program.update - 'program' can not be null");
        }
        this.getHibernateTemplate().update((Object)program);
    }

    @Override
    public void update(final Collection<Program> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Program.update - 'entities' can not be null");
        }
        this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator entityIterator = entities.iterator();
                while (entityIterator.hasNext()) {
                    ProgramDaoBase.this.update((Program)entityIterator.next());
                }
                return null;
            }
        });
    }

    @Override
    public void remove(Program program) {
        if (program == null) {
            throw new IllegalArgumentException("Program.remove - 'program' can not be null");
        }
        this.getHibernateTemplate().delete((Object)program);
    }

    @Override
    public void remove(String code) {
        if (code == null) {
            throw new IllegalArgumentException("Program.remove - 'code' can not be null");
        }
        String entityPk = code;
        Program entity = this.load(code);
        if (entity != null) {
            this.remove(entity);
        }
    }

    @Override
    public void remove(Collection<Program> entities) {
        if (entities == null) {
            throw new IllegalArgumentException("Program.remove - 'entities' can not be null");
        }
        this.getHibernateTemplate().deleteAll(entities);
    }

    protected Object transformEntity(int transform, Program entity) {
        Program target = null;
        if (entity != null) {
            switch (transform) {
                default: 
            }
            target = entity;
        }
        return target;
    }

    protected void transformEntities(int transform, Collection<?> entities) {
        switch (transform) {
            default: 
        }
    }

    protected Program toEntity(Object[] row) {
        Program target = null;
        if (row != null) {
            for (Object object : row) {
                if (!(object instanceof Program)) continue;
                target = (Program)object;
                break;
            }
        }
        return target;
    }

    protected Principal getPrincipal() {
        return PrincipalStore.get();
    }

    @Override
    public PaginationResult search(int transform, int pageNumber, int pageSize, Search search) {
        try {
            search.setPageNumber(pageNumber);
            search.setPageSize(pageSize);
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ProgramImpl.class, search);
            List results = propertySearch.executeAsList();
            this.transformEntities(transform, results);
            return new PaginationResult(results.toArray(new Object[0]), propertySearch.getTotalCount());
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public PaginationResult search(int pageNumber, int pageSize, Search search) {
        return this.search(0, pageNumber, pageSize, search);
    }

    @Override
    public Set<?> search(int transform, Search search) {
        try {
            PropertySearch propertySearch = new PropertySearch(this.getSession(false), ProgramImpl.class, search);
            Set results = propertySearch.executeAsSet();
            this.transformEntities(transform, results);
            return results;
        }
        catch (HibernateException ex) {
            throw super.convertHibernateAccessException(ex);
        }
    }

    @Override
    public Set<Program> search(Search search) {
        return this.search(0, search);
    }
}

