package fr.ifremer.adagio.core.service.technical;

/*
 * #%L
 * SIH-Adagio Core Shared
 * $Id: CacheServiceImpl.java 11975 2014-02-12 17:56:29Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.6.4/core-shared/src/main/java/fr/ifremer/adagio/core/service/technical/CacheServiceImpl.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

@Component(value = "cacheService")
@Lazy
public class CacheServiceImpl implements CacheService {
    /** Logger. */
    private static final Log logger =
            LogFactory.getLog(CacheServiceImpl.class);

    @Resource(name = "cacheManager")
    private CacheManager cacheManager;

    @Resource(name = "ehcache")
    private net.sf.ehcache.CacheManager ehCacheManager;

    @Override
    public void clearAllCaches() {
        logger.info("Clearing all caches...");
        for (String cacheName : cacheManager.getCacheNames()) {
            Cache cache = cacheManager.getCache(cacheName);
            cache.clear();
        }

        ehCacheManager.clearAll();
    }

    @Override
    public void clearCache(String cacheName) {
        logger.info("Clearing cache " + cacheName + "...");
        Cache cache = cacheManager.getCache(cacheName);
        if (cache != null) {
            cache.clear();
            return;
        }

        net.sf.ehcache.Cache ehCache = ehCacheManager.getCache(cacheName);
        if (ehCache != null) {
            ehCache.removeAll();
            return;
        }

        logger.warn("Unable to clear cache. Cache with name '" + cacheName + "' could not found.");
    }

    @Override
    public Cache getCache(String cacheName) {
        Cache cache = cacheManager.getCache(cacheName);
        if (cache == null) {
            net.sf.ehcache.Cache ehCache = ehCacheManager.getCache(cacheName);
            if (ehCache != null) {
                logger.warn("Asking for a spring cache with name '" + cacheName + "', but correspond to a EhCache instance. WIll return null.");
            }
        }
        return cache;
    }
}
