package fr.ifremer.adagio.core.service.referential.location;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */



/**
 * @author Tony Chemit <tchemit@codelutin.com>
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 *
 */
public class LocationUtils {
	
    private static final double EARTH_RADIUS = 6378288.0;
    
	protected LocationUtils() {
		// Should not be instantiate
	}
    
    public static String computeStatisticalRectangle(Float latitude, Float longitude) {
		if (longitude == null || latitude == null) {
			return null;
		}
		String locationLabel = null;

		// If position inside "Mediterranean and black sea" :
		if (((longitude >= 0 && longitude < 42) && (latitude >= 30 && latitude < 47.5))
				|| ((longitude >= -6 && longitude < 0) && (latitude >= 35 && latitude < 40))) {

			// Number of rectangles, between the given latitude and 30°N :
			double nbdemidegreeLat = Math.floor((latitude - 30)) * 2;

			// Number of rectangles, between the given longitude and 6°W :
			double nbdemidegreeLong = Math.floor((longitude + 6)) * 2;

			// Letter change every 10 rectangles, starting with 'A' :
			char letter = new Character((char) ((int) (Math.floor(nbdemidegreeLong / 10) + 65))).charValue();
			int rest = (int) (nbdemidegreeLong % 10);
			locationLabel = "M" + String.valueOf((int) nbdemidegreeLat) + letter + String.valueOf(rest); //$NON-NLS-1$
		}

		// If position inside "Atlantic (nord-east)" :
		else if ((longitude >= -50 && longitude <= 70) && (latitude >= 36 && latitude <= 89)) {
			int halfDegreesNb = (int) Math.floor((latitude - 36) * 2) + 1;
			double degreesNb = Math.floor(longitude + 50);
			char letter = new Character((char) ((int) (Math.floor(degreesNb / 10) + 65))).charValue();
			int rest = (int) (degreesNb % 10);
			locationLabel = String.valueOf(halfDegreesNb) + letter + String.valueOf(rest);
		}
		return locationLabel;
	}
    
    public static int computeDistanceInMeters(Float startLatitude,
                                              Float startLongitude,
                                              Float endLatitude,
                                              Float endLongitude) {

        double sLat = startLatitude * Math.PI / 180.0;
        double sLong = startLongitude * Math.PI / 180.0;
        double eLat = endLatitude * Math.PI / 180.0;
        double eLong = endLongitude * Math.PI / 180.0;

        Double d = EARTH_RADIUS *
                   (Math.PI / 2 - Math.asin(Math.sin(eLat) * Math.sin(sLat)
                                            + Math.cos(eLong - sLong) * Math.cos(eLat) * Math.cos(sLat)));
        return d.intValue();
    }

    public static String getDistanceInMilles(Float distance) {
        String distanceText;
        if (distance != null) {
            Float distanceInMilles = distance / 1852;
            distanceText = String.format("%.3f", distanceInMilles);

        } else {
            distanceText = "";
        }
        return distanceText;
    }
}
