package fr.ifremer.adagio.core.dao.technical.hibernate;

/*
 * #%L
 * SIH-Adagio Core Shared
 * $Id: HibernateConnectionProvider.java 12180 2014-07-29 15:59:53Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.6.4/core-shared/src/main/java/fr/ifremer/adagio/core/dao/technical/hibernate/HibernateConnectionProvider.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;

import javax.sql.DataSource;

import org.hibernate.HibernateException;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.exception.spi.Configurable;
import org.hibernate.service.UnknownUnwrapTypeException;
import org.hibernate.service.spi.Stoppable;

public class HibernateConnectionProvider implements ConnectionProvider,Configurable,Stoppable {

    private static final long serialVersionUID = 6463355546534159477L;
    
	private static DataSource dataSource = null;

    @Override
    public void configure(Properties props) throws HibernateException {
        if (dataSource == null) {
            throw new HibernateException("DataSource must be set before using ConnectionProvider.");
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return dataSource.getConnection();
    }

    @Override
    public void closeConnection(Connection conn) throws SQLException {
        if (conn != null && !conn.isClosed()) {
            conn.close();
        }
    }

    @Override
    public void stop(){
        // Release datasource
        dataSource = null;
    }

    @Override
    public boolean supportsAggressiveRelease() {
        // TODO A quoi cela sert il ?
        return false;
    }

    public static DataSource getDataSource() {
        return dataSource;
    }

    public static void setDataSource(DataSource dataSource) {
        HibernateConnectionProvider.dataSource = dataSource;
    }

    @SuppressWarnings("rawtypes")
	@Override
    public boolean isUnwrappableAs(Class unwrapType) {
		return ConnectionProvider.class.equals(unwrapType) ||
		HibernateConnectionProvider.class.isAssignableFrom(unwrapType);
    }

	@SuppressWarnings("unchecked")
    @Override
    public <T> T unwrap(Class<T> unwrapType) {
		if (ConnectionProvider.class.equals(unwrapType) ||
				HibernateConnectionProvider.class.isAssignableFrom(unwrapType)) {
			return (T) this;
		} else {
			throw new UnknownUnwrapTypeException(unwrapType);
		}
    }

}
