package fr.ifremer.adagio.core.config;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: TuttiConfigurationProvider.java 1418 2013-12-01 21:18:22Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/tutti/TuttiConfigurationProvider.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.l;

import java.util.List;
import java.util.Locale;

import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;

import com.google.common.collect.Lists;

import fr.ifremer.adagio.core.dao.technical.AdagioEnumerationDef;

/**
 * Allegro config provider (for site generation).
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.5.0
 */
public class AdagioConfigurationModelEnumProvider implements ApplicationConfigProvider {

	@Override
	public String getName() {
		return "adagio-core-shared-db-enumerations";
	}

	@Override
	public String getDescription(Locale locale) {
		return l(locale, "adagio-db-enumerations.config");
	}

	@Override
	public ConfigOptionDef[] getOptions() {
		List<ConfigOptionDef> options = Lists.newArrayList();

		// Add options from model enumerations
		List<AdagioEnumerationDef<?>> enumDefs = AdagioEnumerationHelper.getAllModelEnumerations();
		for(AdagioEnumerationDef<?> enumDef: enumDefs) {
			AdagioEnumerationOption option = new AdagioEnumerationOption(enumDef);
			options.add(option);
		}
		
		return options.toArray(new ConfigOptionDef[options.size()]);
	}

	@Override
	public ConfigActionDef[] getActions() {
		return new ConfigActionDef[0];
	}	
	
	static class AdagioEnumerationOption implements ConfigOptionDef {

	    private static final long serialVersionUID = -5720186783497571417L;
	    
		private AdagioEnumerationDef<?> delegatedEnum;
		
		public AdagioEnumerationOption(AdagioEnumerationDef<?> delegatedEnum) {
			this.delegatedEnum = delegatedEnum;
		}

		@Override
		public boolean isFinal() {
			return false;
		}

		@Override
		public boolean isTransient() {
			return false;
		}

		@Override
		public String getDefaultValue() {
			return delegatedEnum.getValueAsString();
		}

		@Override
		public String getDescription() {
			return delegatedEnum.getDescription();
		}

		@Override
		public String getKey() {
			return delegatedEnum.getKey();
		}

		@SuppressWarnings({ "unchecked", "rawtypes" })
        @Override
		public Class getType() {
			return delegatedEnum.getType();
		}

		@Override
		public void setDefaultValue(String defaultValue) {
			//not used
		}

		@Override
		public void setTransient(boolean isTransient) {
			// not used
		}

		@Override
		public void setFinal(boolean isFinal) {
			// not used
		}
	}
}
