package fr.ifremer.adagio.core.action;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;

public class DatabaseStatusAction {
    /* Logger */
    private static final Log log = LogFactory.getLog(DatabaseStatusAction.class);

    public void run() {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        
        if (log.isInfoEnabled()) {
            log.info("Starting database status report...");
        }
        ActionUtils.logConnectionProperties();
        
        boolean isValidConnection = DaoUtils.isValidConnectionProperties(config.getJdbcDriver(),
                config.getJdbcURL(),
                config.getJdbcUsername(),
                config.getJdbcPassword()); 
        
        if (!isValidConnection) {
            log.warn("Connection error : could not check database status.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);

        // Check if database is well loaded
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn("Database not start ! Could not check database status.");
            return;
        }

        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            if (actualDbVersion != null) {
                log.info("Database schema version is: " + actualDbVersion.toString());
            }

            Version expectedDbVersion = databaseSchemaService.getApplicationVersion();
            log.info("Database schema version AFTER an update should be: " + expectedDbVersion.toString());
        } catch (AdagioTechnicalException e) {
            log.error("Error while getting versions.", e);
        }
        
        File outputFile = ActionUtils.checkAndGetOutputFile(false, this.getClass());

        try {
            log.info("Launching status report generation...");
            databaseSchemaService.generateStatusReport(outputFile);
            if (outputFile != null) {
                log.info(String.format("Database status report successfullly generated at %s", outputFile));
            }
            else {
                log.info("Database status report successfullly generated.");
            }
        } catch (AdagioTechnicalException e) {
            log.error("Error while writing database status report.", e);
        } catch (IOException e) {
            log.error("Error while writing database status report.", e);
        }
    }

}
