package fr.ifremer.adagio.core.type;

/*
 * #%L
 * Ifremer shared :: Application
 * $Id: ApplicationProgressionModel.java 1379 2013-11-24 22:44:33Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/application/tags/ifremer-shared-1.0.1/application/src/main/java/fr/ifremer/shared/application/type/ApplicationProgressionModel.java $
 * %%
 * Copyright (C) 2013 Ifremer, CodeLutin, Tony CHEMIT
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.beans.PropertyChangeSupport;

/**
 * Simple model for a progression long task.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0
 * @deprecacted use fr.ifremer.adagio.synchro.type.ProgressionModel
 */
@Deprecated
public class ProgressionModel extends PropertyChangeSupport {

 
	private static final long serialVersionUID = 1L;

    public static final String PROPERTY_TOTAL = "total";

    public static final String PROPERTY_CURRENT = "current";

    public static final String PROPERTY_RATE = "rate";

    public static final String PROPERTY_MESSAGE = "message";

    protected int total;

    protected int current;

    protected float rate;

    protected String message;

    /**
     * Constructs a <code>ApplicationProgressionModel</code> object.
     *
     * @param sourceBean  The bean to be given as the source for any events.
     */
    public ProgressionModel(Object sourceBean) {
	    super(sourceBean);
    }

    public int getTotal() {
        return total;
    }

    public void setTotal(int total) {
        Object oldValue = getTotal();
        this.total = total;
        firePropertyChange(PROPERTY_TOTAL, oldValue, total);
        setCurrent(0);
    }

    public void adaptTotal(int total) {
        int current = getCurrent();
        setTotal(total);
        increments(current);
        Object oldValue = getTotal();
        this.total = total;
        firePropertyChange(PROPERTY_TOTAL, oldValue, total);
        setCurrent(current);
    }

    public int getCurrent() {
        return current;
    }

    public void setCurrent(int current) {
        Object oldValue = getCurrent();
        this.current = current;
        firePropertyChange(PROPERTY_CURRENT, oldValue, current);
    }

    public void increments(int nb) {
        setCurrent(current + nb);
        setRate(getCurrent() / getTotal());
    }

    public float getRate() {
        return rate;
    }

    public void setRate(float rate) {
        Object oldValue = getRate();
        this.rate = rate;
        firePropertyChange(PROPERTY_RATE, oldValue, rate);
    }

    public String getMessage() {
        return message;
    }

    public void increments(String message) {
        increments(1);
        setMessage(message);
    }

    public void setMessage(String message) {
        Object oldValue = getMessage();
        this.message = message;
        firePropertyChange(PROPERTY_MESSAGE, oldValue, message);
    }
}
