package fr.ifremer.adagio.core.test;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: TestUtil.java 607 2013-04-21 12:34:44Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/trunk/adagio/core-allegro/src/test/java/fr/ifremer/adagio/core/TestUtil.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.junit.Assume;
import org.junit.Ignore;

import fr.ifremer.adagio.core.service.ServiceLocator;

import java.io.File;

/**
 * Useful method around tests.
 * 
 * 
 * @author tchemit <chemit@codelutin.com>
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.3.1
 */
@Ignore
public final class TestUtil {

    protected TestUtil() {
    }

    /** Logger. */
    private static final Log log = LogFactory.getLog(TestUtil.class);

    public static void checkDbExists(Class<?> testClass, String dbDirectory) {
        File db = new File(dbDirectory);
        if (!db.exists()) {

            if (log.isWarnEnabled()) {
                log.warn("Could not find db at " + db + ", test [" +
                        testClass + "] is skipped.");
            }
            Assume.assumeTrue(false);
        }
    }

    public static <S> S getBean(String name, Class<S> serviceType) {
        S result = ServiceLocator.instance().getService(name, serviceType);
        Assume.assumeNotNull(result);
        return result;
    }

    public static Query createStatelessQuery(String hqlQuery) {
        SessionFactory sessionFactory = getBean("sessionFactory", SessionFactory.class);
        StatelessSession session = sessionFactory.openStatelessSession();
        Query query = session.createQuery(hqlQuery);
        return query;
    }

    public static long countEntities(Class<?> entityClass) {
        return countEntities(entityClass, null, "");
    }

    public static long countEntities(Class<?> entityClass, String alias, String whereClause) {
        if (StringUtils.isNotBlank(whereClause)) {
            whereClause = " " + alias + " where " + whereClause;
        }
        Query query = createStatelessQuery("select count(*) from " + entityClass.getName() + whereClause);
        return (Long) query.uniqueResult();
    }
}
