package fr.ifremer.adagio.core.test;

/*
 * #%L
 * SIH-Adagio Core for Allegro
 * $Id: BaseDaoTest.java 11926 2014-01-13 11:20:10Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/trunk/adagio/core-allegro/src/test/java/fr/ifremer/adagio/core/dao/BaseDaoTest.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;

import fr.ifremer.adagio.core.service.ServiceLocator;

public abstract class AsbtractDaoTest {

	/** Logger. */
	private static final Log log = LogFactory.getLog(AsbtractDaoTest.class);

	private static PlatformTransactionManager transactionManager;

	private TransactionStatus status;
	
	private boolean commitOnTearDown = true;

	@BeforeClass
	public static void beforeClass() {
		transactionManager = TestUtil.getBean("transactionManager", PlatformTransactionManager.class);
	}

	@Before
	public void setUp() throws Exception {
		status = transactionManager.getTransaction(null);
		if (log.isDebugEnabled()) {
			log.debug("Session and transaction initialized");
		}
	}

	@After
	public void tearDown() throws Exception {
		if (commitOnTearDown) {
			transactionManager.commit(status);
		}
		else {
			transactionManager.rollback(status);
		}
	}
	
	/**
	 * Allow to apply a commit on tear down (by default a rollback is applied)
	 * @param commitOnTearDown true to force to commit after unit test
	 */
	protected void setCommitOnTearDown(boolean commitOnTearDown) {
		this.commitOnTearDown = commitOnTearDown;
	}

	

	protected void commit() {
		// Commit
		transactionManager.commit(status);
		// Then open a new transaction
		status = transactionManager.getTransaction(null);
	}
	
	protected <S> S getBean(String name, Class<S> serviceType){
	    return ServiceLocator.instance().getService(name, serviceType);
	}
}
