package fr.ifremer.adagio.core.service.technical;

/*
 * #%L
 * SIH-Adagio Core Shared
 * $Id: CacheService.java 11866 2013-12-02 15:53:58Z tc1fbb1 $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.6.3/core-shared/src/main/java/fr/ifremer/adagio/core/service/technical/CacheService.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.springframework.cache.Cache;

public interface CacheService {

    /**
     * Clear all caches declared in EhCache config.
     */
    void clearAllCaches();

    /**
     * Clear a specific cache declared in EhCache config, using a cache name.</br>
     * If the cache does not exists, it just log a message (warn level).
     *
     * @param cacheName The cache name (or region name) using by EhCache
     */
    void clearCache(String cacheName);

    /**
     * Retrieve spring-cache, or null if not exists
     *
     * @param cacheName
     * @return
     */
    Cache getCache(String cacheName);
}
