package fr.ifremer.adagio.core.service;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */



import java.io.File;
import java.io.IOException;

import org.nuiton.util.version.Version;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly = true)
public interface DatabaseSchemaService {

	Version getDbVersion();

	Version getApplicationVersion();

	@Transactional(readOnly = false)
	void updateSchema();
	
	/**
     * Check if connection could be open.
     * If a validation query has been set in configuration, test it
     * @return if db is loaded
     */
    boolean isDbLoaded();
    
    /**
     * Check if db files exists. If not a database file, return true
     * @return if db files exists
     */
    boolean isDbExists();
    
    /**
     * Report into a file the liquibase status of database 
     */
    public void generateStatusReport(File outputFile) throws IOException;
    
    /**
     * Generate a diff report, from Hibernate model to database 
     */
    public void generateDiffReport(File outputFile) throws IOException;
    
    /**
     * Generate a diff changelog, from Hibernate model to database 
     */
    public void generateDiffChangeLog(File outputFile) throws IOException;
}