package fr.ifremer.adagio.core.dao.technical.hibernate;

/*
 * #%L
 * SIH-Adagio Core Shared
 * $Id: TemporaryDataHelper.java 12443 2014-11-25 16:57:07Z bl05b3e $
 * $HeadURL: https://forge.ifremer.fr/svn/sih-adagio/tags/adagio-3.8.6.3/core-shared/src/main/java/fr/ifremer/adagio/core/dao/technical/hibernate/TemporaryDataHelper.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;

import com.google.common.base.Preconditions;

import java.io.Serializable;

public class TemporaryDataHelper {

    public static final String TEMPORARY_NAME_PREFIX = "#TEMP¿";

    /**
     * Generate a new ID for temporary data (negative value)
     *
     * @param <T>
     * @param session
     * @param entityClass
     * @return
     * @throws HibernateException
     */
    public static <T> T getNewNegativeIdForTemporaryData(Session session, Class<? extends Serializable> entityClass) throws HibernateException {
        String entityName = entityClass.getSimpleName();
        if (!entityName.endsWith("Impl")) {
            entityName += "Impl";
        }
        // Generate a new id for referenceTaxon
        Query query = session.createQuery("SELECT coalesce(min(id),0) - 1 FROM " + entityName + " WHERE id <= 0");
        T result = (T) query.uniqueResult();

        return result;
    }
    
    
    public static String removeTemporaryNamePrefix(String code) {
        if (code != null && code.startsWith(TEMPORARY_NAME_PREFIX)) {
            return code.substring(TEMPORARY_NAME_PREFIX.length());
        }
        return code;
    }

    public static String replaceTemporaryNamePrefix(String code, String replacement) {
        if (code != null && code.startsWith(TEMPORARY_NAME_PREFIX)) {
            return replacement + code.substring(TEMPORARY_NAME_PREFIX.length());
        }
        return code;
    }

    /**
     * Compute a label from prefix and a negative id : #TEMP¿1 , #TEMP¿2 
     * @param negativeId a id use for temporay referential data (should be negative)
     * @return
     * @throws HibernateException
     */
    public static String getTemporaryLabelFromNegativeId(int negativeId) throws HibernateException {
        Preconditions.checkArgument(negativeId < 0);
        return TemporaryDataHelper.TEMPORARY_NAME_PREFIX 
                + Integer.toString(-1 * negativeId);
    }
    
    public static boolean isTemporaryId(Number id) {
        return id != null && id.intValue() < 0;                
    }
    
    public static boolean isTemporaryCode(String code) {
        return code != null && code.startsWith(TEMPORARY_NAME_PREFIX);                
    }
}
