package fr.ifremer.adagio.core.dao.technical;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.util.DateUtil;

import com.google.common.base.Preconditions;

public class DateUtils extends org.apache.commons.lang3.time.DateUtils{
	private static Calendar calendar = new GregorianCalendar();
	
	/**
     * Remove a amount of month to a date
     * @param date
     * @param amount the amount to remove, in month 
     * @return a new date (= the given date - amount in month) 
     */
    public static Date removeMonth(Date date, int amount) {
    	Preconditions.checkNotNull(date);
    	Preconditions.checkArgument(amount > 0);
    	
    	// Compute the start date
		calendar.setTimeInMillis(date.getTime());
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.DAY_OF_MONTH, 1);
		calendar.set(Calendar.MONTH, calendar.get(Calendar.MONTH)-amount);
		return calendar.getTime();
    }
    
	/**
     * Get the number of days between two dates
     * @param startDate
     * @param endDate
     * @return a number of hours
     */
    public static double hoursBetween(Date startDate, Date endDate){
    	double millis = endDate.getTime() - startDate.getTime();
    	double hours = millis / (1000 * 60 * 60);
        return hours;
    }
    
    /**
     * Add to date some hours
     * @param date
     * @param amount
     * @return a date (= date + amount)
     */
    public static Date addHours(Date date, Double amount){
    	long millis = (long) (date.getTime() +  amount.doubleValue() * (1000 * 60 * 60));
        return new Date(millis);
    }
    

    /**
     * Get the last second time of a day: 23:59:59 (0 millisecond)
     * @param date
     * @return
     */
    public static Date lastSecondOfTheDay(Date date) {
        calendar.setTime(date);
        calendar.set(Calendar.HOUR_OF_DAY, 23);
        calendar.set(Calendar.MINUTE, 59);
        calendar.set(Calendar.SECOND, 59);
        calendar.set(Calendar.MILLISECOND, 0);
        return calendar.getTime();
    }
    
    public static int getDifferenceInDays(Date startDate, Date endDate) {
    	return DateUtil.getDifferenceInDays(startDate, endDate);
    }
    
    public static String formatDate(Date date, String pattern) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
        return simpleDateFormat.format(date);
    }
    
    /**
     * Convert to a date, or return null if parse error
     * @param date
     * @param pattern
     * @return
     */
    public static Date safeParseDate(String date, String pattern) {
        Date result = null;
        if (StringUtils.isNotBlank(date)) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(pattern);
                result = simpleDateFormat.parse(date);
            } catch (ParseException ex) {
            }
        }
        return result;
    }
}
