package fr.ifremer.adagio.core.dao.technical;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */



public interface AdagioEnumerationDef<T> {

	static final String CONFIG_OPTION_PREFIX = "adagio.enumeration.";
	
    /** @return la clef identifiant l'option */
    String getKey();

    /** @return le type de l'option */
    Class<?> getType();

    /** @return la clef i18n de description de l'option */
    String getDescription();

    /**
	 * reload value from application config 
	 * @param applicationConfig the applicationConfig to use to reload value
	 */
	void setValue(T value);
	
	String getValueAsString();
	
	T getValue();
}
