package fr.ifremer.adagio.core.config;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: TuttiConfigurationProvider.java 1418 2013-12-01 21:18:22Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/tutti/TuttiConfigurationProvider.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.l;

import java.util.Locale;

import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.config.ConfigOptionDef;

/**
 * Allegro config provider (for site generation).
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.4.3
 */
public class AdagioConfigurationProvider implements ApplicationConfigProvider {

	@Override
	public String getName() {
		return "adagio-core-shared";
	}

	@Override
	public String getDescription(Locale locale) {
		return l(locale, "adagio.config");
	}

	@Override
	public ConfigOptionDef[] getOptions() {
		return AdagioConfigurationOption.values();
	}

	@Override
	public ConfigActionDef[] getActions() {
		return new ConfigActionDef[0];
	}	
}
