package fr.ifremer.adagio.core.config;

/*
 * #%L
 * Tutti :: Persistence
 * $Id: TuttiConfigurationOption.java 1441 2013-12-09 20:13:47Z tchemit $
 * $HeadURL: http://svn.forge.codelutin.com/svn/tutti/trunk/tutti-persistence/src/main/java/fr/ifremer/tutti/TuttiConfigurationOption.java $
 * %%
 * Copyright (C) 2012 - 2013 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import static org.nuiton.i18n.I18n.n;

import java.io.File;
import java.net.URL;
import java.util.Locale;

import org.hibernate.dialect.HSQLDialect;
import org.nuiton.config.ConfigOptionDef;
import org.nuiton.util.version.Version;

/**
 * All application configuration options.
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.4.3
 */
public enum AdagioConfigurationOption implements ConfigOptionDef {

	// ------------------------------------------------------------------------//
	// -- READ-ONLY OPTIONS ---------------------------------------------------//
	// ------------------------------------------------------------------------//

    BASEDIR(
	        "adagio.basedir",
	        n("adagio.config.option.basedir.description"),
	        "${user.home}/.adagio",
	        File.class),

	DATA_DIRECTORY(
	        "adagio.data.directory",
	        n("adagio.config.option.data.directory.description"),
	        "${adagio.basedir}/data",
	        File.class),

    I18N_DIRECTORY(
	        "adagio.i18n.directory",
	        n("adagio.config.option.i18n.directory.description"),
	        "${adagio.basedir}/i18n",
	        File.class),

	TMP_DIRECTORY(
	        "adagio.tmp.directory",
	        n("adagio.config.option.tmp.directory.description"),
	        "${adagio.data.directory}/temp",
	        File.class),

    SYNCHRO_DIRECTORY(
            "adagio.synchro.directory",
            n("adagio.config.option.synchro.directory.description"),
            "${adagio.data.directory}/synchro",
            File.class),

	DB_DIRECTORY(
	        "adagio.persistence.db.directory",
	        n("adagio.config.option.persistence.db.directory.description"),
	        "${adagio.data.directory}/db",
	        File.class),

	DB_ATTACHMENT_DIRECTORY(
	        "adagio.persistence.db.attachment.directory",
	        n("adagio.config.option.persistence.db.attachment.directory.description"),
	        "${adagio.data.directory}/meas_files",
	        File.class),

	DB_CACHE_DIRECTORY(
	        "adagio.persistence.db.cache.directory",
	        n("adagio.config.option.persistence.db.cache.directory.description"),
	        "${adagio.data.directory}/dbcache",
	        File.class),

	DB_NAME(
	        "adagio.persistence.db.name",
	        n("adagio.config.option.persistence.db.name.description"),
	        "allegro",
	        String.class),

    DB_HOST (
            "adagio.persistence.db.host",
            n("adagio.config.option.persistence.db.host.description"),
            "",
            String.class),

    DB_PORT (
            "adagio.persistence.db.port",
            n("adagio.config.option.persistence.db.port.description"),
            "",
            String.class),

	DB_VALIDATION_QUERY(
	        "adagio.persistence.db.validation-query",
	        n("adagio.persistence.db.validation-query.description"),
	        "SELECT COUNT(*) FROM STATUS",
	        String.class),
            
    DB_CREATE_SCRIPT_PATH (
            "adagio.persistence.db.script",
            n("adagio.config.option.db.script.description"),
            "classpath:fr/ifremer/adagio/core/db/changelog/allegro.script",
            String.class,
            false),

    DB_CHECK_CONSTANTS(
            "adagio.persistence.checkConstants.enable",
            n("adagio.config.option.persistence.checkConstants.description"),
            String.valueOf(true),
            Boolean.class),

    DATASOURCE_TYPE(
	        "adagio.persistence.datasource.type",
	        n("adagio.persistence.datasource.type.description"),
	        "local",
	        String.class),

	DATASOURCE_JNDI_NAME(
	        "adagio.persistence.jndi-name",
	        n("adagio.config.option.persistence.jndi-name.description"),
	        "java:comp/env/jdbc/adagio-ds",
	        String.class),	        

	JDBC_USERNAME(
	        "adagio.persistence.jdbc.username",
	        n("adagio.config.option.persistence.jdbc.username.description"),
	        "sa",
	        String.class),

	JDBC_PASSWORD(
	        "adagio.persistence.jdbc.password",
	        n("adagio.config.option.persistence.jdbc.password.description"),
	        "",
	        String.class),

    JDBC_URL(
	        "adagio.persistence.jdbc.url",
	        n("adagio.config.option.persistence.jdbc.url.description"),
	        "jdbc:hsqldb:file:${adagio.persistence.db.directory}/${adagio.persistence.db.name}",
	        String.class),

    JDBC_CATALOG(
            "adagio.persistence.jdbc.catalog",
            n("adagio.config.option.persistence.jdbc.catalog.description"),
            null,
            String.class),

	JDBC_SCHEMA(
	        "adagio.persistence.jdbc.schema",
	        n("adagio.config.option.persistence.jdbc.schema.description"),
	        "PUBLIC",
	        String.class),

	JDBC_DRIVER(
	        "adagio.persistence.jdbc.driver",
	        n("adagio.config.option.persistence.jdbc.driver.description"),
	        "org.hsqldb.jdbcDriver",
            Class.class),

    JDBC_BATCH_SIZE(
	        "adagio.persistence.jdbc.batch-size",
	        n("adagio.config.option.persistence.jdbc.batch-size.description"),
	        "15",
	        Integer.class),

	HIBERNATE_DIALECT(
	        "adagio.persistence.hibernate.dialect",
	        n("adagio.config.option.persistence.hibernate.dialect.description"),
	        HSQLDialect.class.getName(),
	        Class.class),

	DEBUG_ENTITY_LOAD(
	        "adagio.persistence.hibernate.load.debug",
	        n("adagio.config.option.persistence.hibernate.load.debug.description"),
	        Boolean.FALSE.toString(),
	        boolean.class),

	VERSION(
	        "adagio.version",
	        n("adagio.config.option.persistence.version.description"),
	        "3.8.6.1",
	        Version.class),

	SITE_URL(
	        "adagio.site.url",
	        n("adagio.config.option.site.url.description"),
	        "http://www.ifremer.fr/sih-adagio",
	        URL.class),

	ORGANIZATION_NAME(
	        "adagio.organizationName",
	        n("adagio.config.option.organizationName.description"),
	        "Ifremer",
	        String.class),

	INCEPTION_YEAR(
	        "adagio.inceptionYear",
	        n("adagio.config.option.inceptionYear.description"),
	        "2011",
	        Integer.class),

    // ------------------------------------------------------------------------//
    // -- DATA CONSTANTS  --------------------------------------------------//
    // ------------------------------------------------------------------------//
	        
    STATUS_CODE_TEMPORARY(
            "adagio.enumeration.StatusCode.TEMPORARY",
            n("adagio.enumeration.StatusCode.TEMPORARY.description"),
            "2",
            String.class),

    STATUS_CODE_ENABLE(
            "adagio.enumeration.StatusCode.ENABLE",
            n("adagio.enumeration.StatusCode.ENABLE.description"),
            "1",
            String.class),

    PROGRAM_CODE_VESSEL_REGISTRY(
            "adagio.enumeration.ProgramCode.SIH",
            n("adagio.enumeration.ProgramCode.SIH.description"),
            "SIH",
            String.class),

    IMPORT_TRANSCRIBING_ITEM_TYPE_IDS(
            "adagio.synchro.import.transcribingTypeIds",
            n("adagio.config.option.synchro.import.transcribingTypeIds.description"),
            "",
            String.class),
            
    IMPORT_GROUPING_CLASSIFICATION_IDS(
            "adagio.synchro.import.groupingClassificationIds",
            n("adagio.config.option.synchro.import.groupingClassificationIds.description"),
            "",
            String.class),
            
    IMPORT_PROGRAM_CODES(
            "adagio.synchro.import.programs",
            n("adagio.config.option.synchro.import.programs.description"),
            "",
            String.class),
            
    IMPORT_DATA_PK_INCLUDES(
            "adagio.synchro.import.pk.includes",
            n("adagio.config.option.synchro.import.pk.includes.description"),
            "",
            String.class),
            
    IMPORT_NB_YEARS_DATA_HISTORY (
            "adagio.synchro.import.nbYearDataHistory",
            n("adagio.config.option.synchro.import.nbYearDataHistory.description"),
            "2",
            Integer.class),
            
    EXPORT_DATA_UPDATE_DATE_DELAY(
            "adagio.synchro.export.updateDate.offset",
            n("adagio.config.option.synchro.export.data.updateDate.offset.description"),
            String.valueOf(5 * 60), /* 5 min */
            Integer.class),
    
    IMPORT_REFERENTIAL_UPDATE_DATE_OFFSET(
            "adagio.synchro.import.updateDate.offset",
            n("adagio.config.option.synchro.import.referential.updateDate.offset.description"),
            String.valueOf(-60), /* -1 min */
            Integer.class),

    // ------------------------------------------------------------------------//
	// -- READ-WRITE OPTIONS --------------------------------------------------//
	// ------------------------------------------------------------------------//

	DB_BACKUP_DIRECTORY(
	        "adagio.persistence.db.backup.directory",
	        n("adagio.config.option.persistence.db.backup.directory.description"),
	        "${adagio.data.directory}/dbbackup",
	        File.class,
	        false),

	DB_ENUMERATION_RESOURCE(
	        "adagio.persistence.db.enumeration.resource",
	        n("adagio.config.option.persistence.db.enumeration.resource"),
	        "classpath*:adagio-db-enumerations.properties",
	        String.class,
	        false),
	        
   JDBC_BATCH_ENABLE(
           "adagio.persistence.jdbc.batch.enable",
           n("adagio.config.option.persistence.jdbc.batch.enable.description"),
           Boolean.TRUE.toString(),
           Boolean.class,
           false),


	HIBERNATE_SHOW_SQL(
	        "adagio.persistence.hibernate.showSql",
	        n("adagio.config.option.persistence.hibernate.showSql.description"),
	        Boolean.FALSE.toString(),
	        boolean.class,
	        false),

	HIBERNATE_USE_SQL_COMMENT(
	        "adagio.persistence.hibernate.useSqlComment",
	        n("adagio.config.option.persistence.hibernate.useSqlComment.description"),
	        Boolean.FALSE.toString(),
	        boolean.class,
	        false),

	HIBERNATE_FORMAT_SQL(
	        "adagio.persistence.hibernate.formatSql",
	        n("adagio.config.option.persistence.hibernate.formatSql.description"),
	        Boolean.FALSE.toString(),
	        boolean.class,
	        false),

	HIBERNATE_SECOND_LEVEL_CACHE(
	        "adagio.persistence.hibernate.useSecondLevelCache",
	        n("adagio.config.option.persistence.hibernate.useSecondLevelCache.description"),
	        Boolean.FALSE.toString(),
	        boolean.class,
	        false),

	HIBERNATE_CLIENT_QUERIES_FILE(
	        "adagio.persistence.hibernate.queriesFile",
	        n("adagio.config.option.persistence.hibernate.queriesFile.description"),
	        "queries-failsafe.hbm.xml",
	        String.class,
	        false),

	LIQUIBASE_RUN_AUTO(
	        "adagio.persistence.liquibase.should.run",
	        n("adagio.config.option.liquibase.should.run.description"),
	        Boolean.FALSE.toString(),
	        boolean.class,
	        false),

    LIQUIBASE_CHANGE_LOG_PATH(
            "adagio.persistence.liquibase.changelog.path",
            n("adagio.config.option.liquibase.changelog.path.description"),
            "classpath:fr/ifremer/adagio/core/db/changelog/db-changelog-master.xml",
            String.class,
            false),
            
    LIQUIBASE_DIFF_TYPES(
            "adagio.persistence.liquibase.diff.types",
            n("adagio.config.option.liquibase.diff.types.description"),
            null,
            String.class,
            false),            
            
    LIQUIBASE_OUTPUT_FILE(
            "adagio.persistence.liquibase.output.file",
            n("adagio.config.option.liquibase.output.file.description"),
            null,
            File.class,
            false),         

	CACHE_BACTH_TREE(
	        "adagio.persistence.batch.use_tree_cache",
	        n("adagio.config.option.batch.use_tree_cache.description"),
	        Boolean.TRUE.toString(),
	        boolean.class,
	        false),

	CSV_SEPARATOR(
	        "adagio.csv.separator",
	        n("adagio.config.option.csv.separator.description"),
	        ";",
	        char.class,
	        false),

	I18N_LOCALE(
	        "adagio.i18n.locale",
	        n("adagio.config.option.i18n.locale.description"),
	        Locale.FRANCE.getCountry(),
	        Locale.class,
	        false
	);

	/** Configuration key. */
	private final String key;

	/** I18n key of option description */
	private final String description;

	/** Type of option */
	private final Class<?> type;

	/** Default value of option. */
	private String defaultValue;

	/** Flag to not keep option value on disk */
	private boolean isTransient;

	/** Flag to not allow option value modification */
	private boolean isFinal;

	AdagioConfigurationOption(String key,
	                            String description,
	                            String defaultValue,
	                            Class<?> type,
	                            boolean isTransient) {
		this.key = key;
		this.description = description;
		this.defaultValue = defaultValue;
		this.type = type;
		this.isTransient = isTransient;
		this.isFinal = isTransient;
	}

	AdagioConfigurationOption(String key,
	                            String description,
	                            String defaultValue,
	                            Class<?> type) {
		this(key, description, defaultValue, type, true);
	}

	@Override
	public String getKey() {
		return key;
	}

	@Override
	public Class<?> getType() {
		return type;
	}

	@Override
	public String getDescription() {
		return description;
	}

	@Override
	public String getDefaultValue() {
		return defaultValue;
	}

	@Override
	public boolean isTransient() {
		return isTransient;
	}

	@Override
	public boolean isFinal() {
		return isFinal;
	}

	@Override
	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	@Override
	public void setTransient(boolean newValue) {
		// not used
	}

	@Override
	public void setFinal(boolean newValue) {
		// not used
	}
}
