package fr.ifremer.adagio.core.action;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;

public class DatabaseUpdateAction {
    /* Logger */
    private static final Log log = LogFactory.getLog(DatabaseUpdateAction.class);

    public void run() {
        AdagioConfiguration config = AdagioConfiguration.getInstance();

        if (log.isInfoEnabled()) {
            log.info("Starting database schema update...");
        }
        ActionUtils.logConnectionProperties();

        boolean isValidConnection = DaoUtils.isValidConnectionProperties(config.getJdbcDriver(),
                config.getJdbcURL(),
                config.getJdbcUsername(),
                config.getJdbcPassword());

        if (!isValidConnection) {
            log.warn("Connection error: could not update the schema.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);

        // Check if database is well loaded
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn("Database not start ! Could not update the schema.");
            return;
        }

        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            // DB could be null, is DB is empty (mantis #21013)
            if (actualDbVersion != null) {
                log.info("Database schema version is: " + actualDbVersion.toString());
            }

            Version expectedDbVersion = databaseSchemaService.getApplicationVersion();
            log.info("Database schema version AFTER the update should be: " + expectedDbVersion.toString());
        } catch (AdagioTechnicalException e) {
            log.error("Error while getting versions.", e);
        }

        try {
            log.info("Launching update...");
            databaseSchemaService.updateSchema();
            log.info("Database schema successfullly updated.");
        } catch (AdagioTechnicalException e) {
            log.error("Error while updating the database schema.", e);
        }
    }
}
