package fr.ifremer.adagio.core.action;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.io.IOException;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.version.Version;

import fr.ifremer.adagio.core.AdagioTechnicalException;
import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;
import fr.ifremer.adagio.core.service.DatabaseSchemaService;
import fr.ifremer.adagio.core.service.ServiceLocator;

public class DatabaseDiffAction {
    /* Logger */
    private static final Log log = LogFactory.getLog(DatabaseDiffAction.class);

    public void run() {
        AdagioConfiguration config = AdagioConfiguration.getInstance();

        if (log.isInfoEnabled()) {            
            log.info("Starting database schema diff (compare to model)...");
        }
        ActionUtils.logConnectionProperties();

        boolean isValidConnection = DaoUtils.isValidConnectionProperties(config.getJdbcDriver(),
                config.getJdbcURL(),
                config.getJdbcUsername(),
                config.getJdbcPassword()); 

        if (!isValidConnection) {
            log.warn("Connection error: could not report schema diff.");
            return;
        }
        DatabaseSchemaService databaseSchemaService = ServiceLocator.instance().getService("databaseSchemaService", DatabaseSchemaService.class);

        // Check if database is well loaded
        if (!databaseSchemaService.isDbLoaded()) {
            log.warn("Database not start ! Could not report schema diff.");
            return;
        }

        try {
            Version actualDbVersion = databaseSchemaService.getDbVersion();
            if (actualDbVersion != null) {
                log.info("Database schema version is: " + actualDbVersion.toString());
            }

            Version modelVersion = config.getVersion();
            log.info("Model version is: " + modelVersion.toString());
        } catch (AdagioTechnicalException e) {
            log.error("Error while getting versions.", e);
        }

        File outputFile = ActionUtils.checkAndGetOutputFile(false, this.getClass());

        try {
            log.info("Launching diff report generation...");
            databaseSchemaService.generateDiffReport(outputFile);
            if (outputFile != null) {
                log.info(String.format("Database diff successfullly generated at %s", outputFile));
            }
            else {
                log.info("Database diff successfullly generated.");
            }

        } catch (AdagioTechnicalException e) {
            log.error("Error while generating status report file.", e);
        } catch (IOException e) {
            log.error("Error while generating status report file.", e);
        }
    }
}
