package fr.ifremer.adagio.core.action;

/*
 * #%L
 * SIH-Adagio :: Shared
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */


import java.io.File;
import java.util.Set;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.config.ApplicationConfigHelper;
import org.nuiton.config.ApplicationConfigProvider;
import org.nuiton.config.ConfigActionDef;
import org.nuiton.i18n.I18n;

import fr.ifremer.adagio.core.config.AdagioConfiguration;
import fr.ifremer.adagio.core.dao.technical.DaoUtils;

public class ActionUtils {
    /* Logger */
    private static final Log log = LogFactory.getLog(DatabaseChangeLogAction.class);

    protected ActionUtils() {
        // helper class
    }

    public static void logConnectionProperties() {
        if (!log.isInfoEnabled()) {
            return;
        }
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        boolean isFileDatabase = DaoUtils.isFileDatabase(config.getJdbcURL());
        if (isFileDatabase) {
            log.info(String.format(" Database directory: %s", config.getDbDirectory()));
        }
        log.info(String.format(" JDBC Driver: %s", config.getJdbcDriver()));
        log.info(String.format(" JDBC URL: %s", config.getJdbcURL()));
        log.info(String.format(" JDBC Username: %s", config.getJdbcUsername()));
        String jdbcCatalog = config.getJdbcCatalog();
        if (StringUtils.isNotBlank(jdbcCatalog)) {
            log.info(String.format(" JDBC Catalog: %s", jdbcCatalog));
        }
        String jdbcSchema = config.getJdbcSchema();
        if (StringUtils.isNotBlank(jdbcSchema)) {
            log.info(String.format(" JDBC Schema: %s", jdbcSchema));
        }
    }

    /**
     * Check output file or directory validity
     * 
     * @return
     */
    public static File checkAndGetOutputFile(boolean isDirectory, Class<?> actionClass) {
        AdagioConfiguration config = AdagioConfiguration.getInstance();
        
        File output = config.getLiquibaseOutputFile();
        if (output == null) {
            log.error(I18n.t("adagio.action.noOutput.error", "--output [...]", getActionAlias(actionClass)));
            System.exit(-1);
        }
        
        if (output.exists()) {
            if (isDirectory) {
                if (!output.isDirectory()) {
                    log.error(I18n.t("adagio.action.outputNotADirectory.error", output.getPath()));
                    System.exit(-1);
                }
                else if (ArrayUtils.isNotEmpty(output.listFiles())) {
                    log.error(I18n.t("adagio.action.outputNotEmptyDirectory.error", output.getPath()));
                    System.exit(-1);
                }
            }
            else {
                log.error(I18n.t("adagio.action.outputNotAFile.error", output.getPath()));
                System.exit(-1);
            }
        }
        
        return output;
    }
    
    public static String getActionAlias(Class<?> clazz) {
        ConfigActionDef actionDefFound = null;
        
        // Retrieve the configActionDef for the given class
        Set<ApplicationConfigProvider> providers =
                ApplicationConfigHelper.getProviders(null,
                        null,
                        null,
                        true);
        String classname = clazz.getName();
        for(ApplicationConfigProvider provider: providers) {
            ConfigActionDef[] actionDefs = provider.getActions();
            if (ArrayUtils.isNotEmpty(actionDefs)) {
                for (ConfigActionDef actionDef:actionDefs) {
                    if (actionDef.getAction() != null
                            && actionDef.getAction().startsWith(classname)) {
                        actionDefFound = actionDef;
                        break;
                    }
                }
                if (actionDefFound != null) {
                    break;
                }
            }
        }
        
        // If a config action def exists, return the first alias
        if (actionDefFound != null) {
            String[] alias = actionDefFound.getAliases();
            if (ArrayUtils.isNotEmpty(alias)) {
                return alias[0];
            }
        }
        return I18n.t("adagio.action.current");
    }
}
