package fr.ifremer.adagio.core.vo.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.io.File;
import java.io.Serializable;

import com.google.common.base.Preconditions;

/**
 * 
 * @author Benoit Lavenier <benoit.lavenier@e-is.pro>
 * @since 3.7.0
 */
public class SynchroProgressionVO implements Serializable {

	private static final long serialVersionUID = 64396395159800607L;

	private final String jobId;
	private final int increment;
	private final String message;
	private final String status;
	private final String fileName;

	public SynchroProgressionVO(String jobId, String fileName, SynchroProgressionModel progressionModel) {
		Preconditions.checkNotNull(jobId);
		Preconditions.checkNotNull(fileName);
		Preconditions.checkNotNull(progressionModel);
		this.jobId = jobId;
		this.fileName = fileName;
		this.increment = progressionModel.getCurrent();
		this.message = progressionModel.getMessage();
		this.status = progressionModel.getStatus().toString();
	}

	public SynchroProgressionVO(String jobId, File outputFile, SynchroProgressionModel progressionModel) {
		Preconditions.checkNotNull(jobId);
		Preconditions.checkNotNull(outputFile);
		Preconditions.checkNotNull(progressionModel);
		this.jobId = jobId;
		this.fileName = outputFile.getName();
		this.increment = progressionModel.getCurrent();
		this.message = progressionModel.getMessage();
		this.status = progressionModel.getStatus().toString();
	}

	public int getIncrement() {
		return increment;
	}

	public String getJobId() {
		return jobId;
	}

	public String getMessage() {
		return message;
	}

	public String getStatus() {
		return status;
	}

	public String getFileName() {
		return fileName;
	}

}
