package fr.ifremer.adagio.core.vo.synchro;

/*
 * #%L
 * SIH-Adagio :: Core for Allegro
 * $Id:$
 * $HeadURL:$
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */

import java.beans.PropertyChangeListener;
import java.io.Serializable;

/**
 * 
 * @author Ludovic Pecquot <ludovic.pecquot@e-is.pro>
 * @since 3.7.0
 */
public interface SynchroProgressionModel extends Serializable {

	static String PROPERTY_CURRENT = "current";

	static String PROPERTY_STATUS = "status";

	static String PROPERTY_MESSAGE = "message";

	static String PROPERTY_TASK = "task";

	String getMessage();

	void setTask(String task);

	String getTask();

	void setMessage(String message);

	int getCurrent();

	void setCurrent(int progression);

	void increments(int increment);

	void increments(String message);

	SynchroProgressionStatus getStatus();

	void setStatus(SynchroProgressionStatus progressionStatus);

	void addPropertyChangeListener(PropertyChangeListener listener);

	void removePropertyChangeListener(PropertyChangeListener listener);
}
